package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediastore.model.primitives.ContainerName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateContainerRequest(
    containerName: ContainerName,
    tags: Optional[Iterable[zio.aws.mediastore.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.CreateContainerRequest = {
    import CreateContainerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.CreateContainerRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.CreateContainerRequest.ReadOnly =
    zio.aws.mediastore.model.CreateContainerRequest.wrap(buildAwsValue())
}
object CreateContainerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.CreateContainerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.CreateContainerRequest =
      zio.aws.mediastore.model.CreateContainerRequest(
        containerName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def containerName: ContainerName
    def tags: Optional[List[zio.aws.mediastore.model.Tag.ReadOnly]]
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.mediastore.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.CreateContainerRequest
  ) extends zio.aws.mediastore.model.CreateContainerRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
    override val tags: Optional[List[zio.aws.mediastore.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediastore.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.CreateContainerRequest
  ): zio.aws.mediastore.model.CreateContainerRequest.ReadOnly = new Wrapper(
    impl
  )
}
