package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class DeleteContainerRequest(containerName: ContainerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.DeleteContainerRequest = {
    import DeleteContainerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.DeleteContainerRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.DeleteContainerRequest.ReadOnly =
    zio.aws.mediastore.model.DeleteContainerRequest.wrap(buildAwsValue())
}
object DeleteContainerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.DeleteContainerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.DeleteContainerRequest =
      zio.aws.mediastore.model.DeleteContainerRequest(containerName)
    def containerName: ContainerName
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.DeleteContainerRequest
  ) extends zio.aws.mediastore.model.DeleteContainerRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.DeleteContainerRequest
  ): zio.aws.mediastore.model.DeleteContainerRequest.ReadOnly = new Wrapper(
    impl
  )
}
