package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class DeleteLifecyclePolicyRequest(containerName: ContainerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.DeleteLifecyclePolicyRequest = {
    import DeleteLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.DeleteLifecyclePolicyRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mediastore.model.DeleteLifecyclePolicyRequest.ReadOnly =
    zio.aws.mediastore.model.DeleteLifecyclePolicyRequest.wrap(buildAwsValue())
}
object DeleteLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.DeleteLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.DeleteLifecyclePolicyRequest =
      zio.aws.mediastore.model.DeleteLifecyclePolicyRequest(containerName)
    def containerName: ContainerName
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.DeleteLifecyclePolicyRequest
  ) extends zio.aws.mediastore.model.DeleteLifecyclePolicyRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.DeleteLifecyclePolicyRequest
  ): zio.aws.mediastore.model.DeleteLifecyclePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
