package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediastore.model.primitives.ContainerName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeContainerRequest(
    containerName: Optional[ContainerName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.DescribeContainerRequest = {
    import DescribeContainerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.DescribeContainerRequest
      .builder()
      .optionallyWith(
        containerName.map(value =>
          ContainerName.unwrap(value): java.lang.String
        )
      )(_.containerName)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.DescribeContainerRequest.ReadOnly =
    zio.aws.mediastore.model.DescribeContainerRequest.wrap(buildAwsValue())
}
object DescribeContainerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.DescribeContainerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.DescribeContainerRequest =
      zio.aws.mediastore.model
        .DescribeContainerRequest(containerName.map(value => value))
    def containerName: Optional[ContainerName]
    def getContainerName: ZIO[Any, AwsError, ContainerName] =
      AwsError.unwrapOptionField("containerName", containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.DescribeContainerRequest
  ) extends zio.aws.mediastore.model.DescribeContainerRequest.ReadOnly {
    override val containerName: Optional[ContainerName] = zio.aws.core.internal
      .optionalFromNullable(impl.containerName())
      .map(value => zio.aws.mediastore.model.primitives.ContainerName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.DescribeContainerRequest
  ): zio.aws.mediastore.model.DescribeContainerRequest.ReadOnly = new Wrapper(
    impl
  )
}
