package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerARN
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resource: ContainerARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.ListTagsForResourceRequest
      .builder()
      .resource(ContainerARN.unwrap(resource): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.mediastore.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.ListTagsForResourceRequest =
      zio.aws.mediastore.model.ListTagsForResourceRequest(resource)
    def resource: ContainerARN
    def getResource: ZIO[Any, Nothing, ContainerARN] = ZIO.succeed(resource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.ListTagsForResourceRequest
  ) extends zio.aws.mediastore.model.ListTagsForResourceRequest.ReadOnly {
    override val resource: ContainerARN =
      zio.aws.mediastore.model.primitives.ContainerARN(impl.resource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.ListTagsForResourceRequest
  ): zio.aws.mediastore.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
