package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.{ObjectGroupName, ObjectGroup}
import scala.jdk.CollectionConverters.*
final case class MetricPolicyRule(
    objectGroup: ObjectGroup,
    objectGroupName: ObjectGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.MetricPolicyRule = {
    import MetricPolicyRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.MetricPolicyRule
      .builder()
      .objectGroup(ObjectGroup.unwrap(objectGroup): java.lang.String)
      .objectGroupName(
        ObjectGroupName.unwrap(objectGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.MetricPolicyRule.ReadOnly =
    zio.aws.mediastore.model.MetricPolicyRule.wrap(buildAwsValue())
}
object MetricPolicyRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.MetricPolicyRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.MetricPolicyRule =
      zio.aws.mediastore.model.MetricPolicyRule(objectGroup, objectGroupName)
    def objectGroup: ObjectGroup
    def objectGroupName: ObjectGroupName
    def getObjectGroup: ZIO[Any, Nothing, ObjectGroup] =
      ZIO.succeed(objectGroup)
    def getObjectGroupName: ZIO[Any, Nothing, ObjectGroupName] =
      ZIO.succeed(objectGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.MetricPolicyRule
  ) extends zio.aws.mediastore.model.MetricPolicyRule.ReadOnly {
    override val objectGroup: ObjectGroup =
      zio.aws.mediastore.model.primitives.ObjectGroup(impl.objectGroup())
    override val objectGroupName: ObjectGroupName =
      zio.aws.mediastore.model.primitives
        .ObjectGroupName(impl.objectGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.MetricPolicyRule
  ): zio.aws.mediastore.model.MetricPolicyRule.ReadOnly = new Wrapper(impl)
}
