package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class PutCorsPolicyRequest(
    containerName: ContainerName,
    corsPolicy: Iterable[zio.aws.mediastore.model.CorsRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.PutCorsPolicyRequest = {
    import PutCorsPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.PutCorsPolicyRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .corsPolicy(corsPolicy.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.PutCorsPolicyRequest.ReadOnly =
    zio.aws.mediastore.model.PutCorsPolicyRequest.wrap(buildAwsValue())
}
object PutCorsPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.PutCorsPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.PutCorsPolicyRequest =
      zio.aws.mediastore.model.PutCorsPolicyRequest(
        containerName,
        corsPolicy.map { item =>
          item.asEditable
        }
      )
    def containerName: ContainerName
    def corsPolicy: List[zio.aws.mediastore.model.CorsRule.ReadOnly]
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
    def getCorsPolicy
        : ZIO[Any, Nothing, List[zio.aws.mediastore.model.CorsRule.ReadOnly]] =
      ZIO.succeed(corsPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.PutCorsPolicyRequest
  ) extends zio.aws.mediastore.model.PutCorsPolicyRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
    override val corsPolicy: List[zio.aws.mediastore.model.CorsRule.ReadOnly] =
      impl
        .corsPolicy()
        .asScala
        .map { item =>
          zio.aws.mediastore.model.CorsRule.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.PutCorsPolicyRequest
  ): zio.aws.mediastore.model.PutCorsPolicyRequest.ReadOnly = new Wrapper(impl)
}
