package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class PutMetricPolicyRequest(
    containerName: ContainerName,
    metricPolicy: zio.aws.mediastore.model.MetricPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.PutMetricPolicyRequest = {
    import PutMetricPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.PutMetricPolicyRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .metricPolicy(metricPolicy.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.PutMetricPolicyRequest.ReadOnly =
    zio.aws.mediastore.model.PutMetricPolicyRequest.wrap(buildAwsValue())
}
object PutMetricPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.PutMetricPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.PutMetricPolicyRequest =
      zio.aws.mediastore.model
        .PutMetricPolicyRequest(containerName, metricPolicy.asEditable)
    def containerName: ContainerName
    def metricPolicy: zio.aws.mediastore.model.MetricPolicy.ReadOnly
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
    def getMetricPolicy
        : ZIO[Any, Nothing, zio.aws.mediastore.model.MetricPolicy.ReadOnly] =
      ZIO.succeed(metricPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.PutMetricPolicyRequest
  ) extends zio.aws.mediastore.model.PutMetricPolicyRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
    override val metricPolicy: zio.aws.mediastore.model.MetricPolicy.ReadOnly =
      zio.aws.mediastore.model.MetricPolicy.wrap(impl.metricPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.PutMetricPolicyRequest
  ): zio.aws.mediastore.model.PutMetricPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
