package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerARN
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resource: ContainerARN,
    tags: Iterable[zio.aws.mediastore.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.TagResourceRequest
      .builder()
      .resource(ContainerARN.unwrap(resource): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.TagResourceRequest.ReadOnly =
    zio.aws.mediastore.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.TagResourceRequest =
      zio.aws.mediastore.model.TagResourceRequest(
        resource,
        tags.map { item =>
          item.asEditable
        }
      )
    def resource: ContainerARN
    def tags: List[zio.aws.mediastore.model.Tag.ReadOnly]
    def getResource: ZIO[Any, Nothing, ContainerARN] = ZIO.succeed(resource)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.mediastore.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.TagResourceRequest
  ) extends zio.aws.mediastore.model.TagResourceRequest.ReadOnly {
    override val resource: ContainerARN =
      zio.aws.mediastore.model.primitives.ContainerARN(impl.resource())
    override val tags: List[zio.aws.mediastore.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.mediastore.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.TagResourceRequest
  ): zio.aws.mediastore.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
