package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.{TagKey, ContainerARN}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resource: ContainerARN,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.UntagResourceRequest
      .builder()
      .resource(ContainerARN.unwrap(resource): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.UntagResourceRequest.ReadOnly =
    zio.aws.mediastore.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.UntagResourceRequest =
      zio.aws.mediastore.model.UntagResourceRequest(resource, tagKeys)
    def resource: ContainerARN
    def tagKeys: List[TagKey]
    def getResource: ZIO[Any, Nothing, ContainerARN] = ZIO.succeed(resource)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.UntagResourceRequest
  ) extends zio.aws.mediastore.model.UntagResourceRequest.ReadOnly {
    override val resource: ContainerARN =
      zio.aws.mediastore.model.primitives.ContainerARN(impl.resource())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.mediastore.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.UntagResourceRequest
  ): zio.aws.mediastore.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
