package zio.aws.memorydb.model
import scala.jdk.CollectionConverters._
sealed trait AZStatus {
  def unwrap: software.amazon.awssdk.services.memorydb.model.AZStatus
}
object AZStatus {
  def wrap(
      value: software.amazon.awssdk.services.memorydb.model.AZStatus
  ): zio.aws.memorydb.model.AZStatus = value match {
    case software.amazon.awssdk.services.memorydb.model.AZStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.memorydb.model.AZStatus.SINGLEAZ =>
      val r = singleaz
      r
    case software.amazon.awssdk.services.memorydb.model.AZStatus.MULTIAZ =>
      val r = multiaz
      r
  }
  case object unknownToSdkVersion extends zio.aws.memorydb.model.AZStatus {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.AZStatus =
      software.amazon.awssdk.services.memorydb.model.AZStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object singleaz extends zio.aws.memorydb.model.AZStatus {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.AZStatus =
      software.amazon.awssdk.services.memorydb.model.AZStatus.SINGLEAZ
  }
  case object multiaz extends zio.aws.memorydb.model.AZStatus {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.AZStatus =
      software.amazon.awssdk.services.memorydb.model.AZStatus.MULTIAZ
  }
}
