package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AuthenticationMode(
    `type`: Optional[zio.aws.memorydb.model.InputAuthenticationType] =
      Optional.Absent,
    passwords: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.AuthenticationMode = {
    import AuthenticationMode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.AuthenticationMode
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        passwords.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.passwords)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.AuthenticationMode.ReadOnly =
    zio.aws.memorydb.model.AuthenticationMode.wrap(buildAwsValue())
}
object AuthenticationMode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.AuthenticationMode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.AuthenticationMode =
      zio.aws.memorydb.model.AuthenticationMode(
        `type`.map(value => value),
        passwords.map(value => value)
      )
    def `type`: Optional[zio.aws.memorydb.model.InputAuthenticationType]
    def passwords: Optional[List[String]]
    def getType
        : ZIO[Any, AwsError, zio.aws.memorydb.model.InputAuthenticationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPasswords: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("passwords", passwords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.AuthenticationMode
  ) extends zio.aws.memorydb.model.AuthenticationMode.ReadOnly {
    override val `type`
        : Optional[zio.aws.memorydb.model.InputAuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.memorydb.model.InputAuthenticationType.wrap(value)
        )
    override val passwords: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.passwords())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.AuthenticationMode
  ): zio.aws.memorydb.model.AuthenticationMode.ReadOnly = new Wrapper(impl)
}
