package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ClusterConfiguration(
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    maintenanceWindow: Optional[String] = Optional.Absent,
    topicArn: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    parameterGroupName: Optional[String] = Optional.Absent,
    subnetGroupName: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    snapshotRetentionLimit: Optional[IntegerOptional] = Optional.Absent,
    snapshotWindow: Optional[String] = Optional.Absent,
    numShards: Optional[IntegerOptional] = Optional.Absent,
    shards: Optional[Iterable[zio.aws.memorydb.model.ShardDetail]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ClusterConfiguration = {
    import ClusterConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(topicArn.map(value => value: java.lang.String))(
        _.topicArn
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(numShards.map(value => value: Integer))(_.numShards)
      .optionallyWith(
        shards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shards)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ClusterConfiguration.ReadOnly =
    zio.aws.memorydb.model.ClusterConfiguration.wrap(buildAwsValue())
}
object ClusterConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ClusterConfiguration =
      zio.aws.memorydb.model.ClusterConfiguration(
        name.map(value => value),
        description.map(value => value),
        nodeType.map(value => value),
        engineVersion.map(value => value),
        maintenanceWindow.map(value => value),
        topicArn.map(value => value),
        port.map(value => value),
        parameterGroupName.map(value => value),
        subnetGroupName.map(value => value),
        vpcId.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        numShards.map(value => value),
        shards.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[String]
    def description: Optional[String]
    def nodeType: Optional[String]
    def engineVersion: Optional[String]
    def maintenanceWindow: Optional[String]
    def topicArn: Optional[String]
    def port: Optional[IntegerOptional]
    def parameterGroupName: Optional[String]
    def subnetGroupName: Optional[String]
    def vpcId: Optional[String]
    def snapshotRetentionLimit: Optional[IntegerOptional]
    def snapshotWindow: Optional[String]
    def numShards: Optional[IntegerOptional]
    def shards: Optional[List[zio.aws.memorydb.model.ShardDetail.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindow)
    def getTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupName)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getNumShards: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numShards", numShards)
    def getShards: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.ShardDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("shards", shards)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
  ) extends zio.aws.memorydb.model.ClusterConfiguration.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val maintenanceWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceWindow())
      .map(value => value: String)
    override val topicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val parameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroupName())
      .map(value => value: String)
    override val subnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetGroupName())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val snapshotRetentionLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionLimit())
        .map(value => value: IntegerOptional)
    override val snapshotWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotWindow())
      .map(value => value: String)
    override val numShards: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.numShards())
      .map(value => value: IntegerOptional)
    override val shards
        : Optional[List[zio.aws.memorydb.model.ShardDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shards())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.ShardDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
  ): zio.aws.memorydb.model.ClusterConfiguration.ReadOnly = new Wrapper(impl)
}
