package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAclResponse(
    acl: Optional[zio.aws.memorydb.model.ACL] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateAclResponse = {
    import CreateAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateAclResponse
      .builder()
      .optionallyWith(acl.map(value => value.buildAwsValue()))(_.acl)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateAclResponse.ReadOnly =
    zio.aws.memorydb.model.CreateAclResponse.wrap(buildAwsValue())
}
object CreateAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateAclResponse =
      zio.aws.memorydb.model
        .CreateAclResponse(acl.map(value => value.asEditable))
    def acl: Optional[zio.aws.memorydb.model.ACL.ReadOnly]
    def getAcl: ZIO[Any, AwsError, zio.aws.memorydb.model.ACL.ReadOnly] =
      AwsError.unwrapOptionField("acl", acl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateAclResponse
  ) extends zio.aws.memorydb.model.CreateAclResponse.ReadOnly {
    override val acl: Optional[zio.aws.memorydb.model.ACL.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acl())
        .map(value => zio.aws.memorydb.model.ACL.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateAclResponse
  ): zio.aws.memorydb.model.CreateAclResponse.ReadOnly = new Wrapper(impl)
}
