package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSnapshotResponse(
    snapshot: Optional[zio.aws.memorydb.model.Snapshot] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse = {
    import CreateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateSnapshotResponse.ReadOnly =
    zio.aws.memorydb.model.CreateSnapshotResponse.wrap(buildAwsValue())
}
object CreateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateSnapshotResponse =
      zio.aws.memorydb.model
        .CreateSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Optional[zio.aws.memorydb.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse
  ) extends zio.aws.memorydb.model.CreateSnapshotResponse.ReadOnly {
    override val snapshot: Optional[zio.aws.memorydb.model.Snapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshot())
        .map(value => zio.aws.memorydb.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse
  ): zio.aws.memorydb.model.CreateSnapshotResponse.ReadOnly = new Wrapper(impl)
}
