package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReservedNodesOfferingsRequest(
    reservedNodesOfferingId: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    duration: Optional[String] = Optional.Absent,
    offeringType: Optional[String] = Optional.Absent,
    maxResults: Optional[IntegerOptional] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest = {
    import DescribeReservedNodesOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest
      .builder()
      .optionallyWith(
        reservedNodesOfferingId.map(value => value: java.lang.String)
      )(_.reservedNodesOfferingId)
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(duration.map(value => value: java.lang.String))(
        _.duration
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.DescribeReservedNodesOfferingsRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeReservedNodesOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeReservedNodesOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.memorydb.model.DescribeReservedNodesOfferingsRequest =
      zio.aws.memorydb.model.DescribeReservedNodesOfferingsRequest(
        reservedNodesOfferingId.map(value => value),
        nodeType.map(value => value),
        duration.map(value => value),
        offeringType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def reservedNodesOfferingId: Optional[String]
    def nodeType: Optional[String]
    def duration: Optional[String]
    def offeringType: Optional[String]
    def maxResults: Optional[IntegerOptional]
    def nextToken: Optional[String]
    def getReservedNodesOfferingId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("reservedNodesOfferingId", reservedNodesOfferingId)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getDuration: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("duration", duration)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest
  ) extends zio.aws.memorydb.model.DescribeReservedNodesOfferingsRequest.ReadOnly {
    override val reservedNodesOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodesOfferingId())
        .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val duration: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: String)
    override val offeringType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringType())
      .map(value => value: String)
    override val maxResults: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: IntegerOptional)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest
  ): zio.aws.memorydb.model.DescribeReservedNodesOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
