package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotsRequest(
    clusterName: Optional[String] = Optional.Absent,
    snapshotName: Optional[String] = Optional.Absent,
    source: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[IntegerOptional] = Optional.Absent,
    showDetail: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest = {
    import DescribeSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(showDetail.map(value => value: java.lang.Boolean))(
        _.showDetail
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeSnapshotsRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeSnapshotsRequest =
      zio.aws.memorydb.model.DescribeSnapshotsRequest(
        clusterName.map(value => value),
        snapshotName.map(value => value),
        source.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        showDetail.map(value => value)
      )
    def clusterName: Optional[String]
    def snapshotName: Optional[String]
    def source: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[IntegerOptional]
    def showDetail: Optional[BooleanOptional]
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getShowDetail: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("showDetail", showDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
  ) extends zio.aws.memorydb.model.DescribeSnapshotsRequest.ReadOnly {
    override val clusterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: String)
    override val snapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value => value: String)
    override val source: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: IntegerOptional)
    override val showDetail: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.showDetail())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
  ): zio.aws.memorydb.model.DescribeSnapshotsRequest.ReadOnly = new Wrapper(
    impl
  )
}
