package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FailoverShardResponse(
    cluster: Optional[zio.aws.memorydb.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.FailoverShardResponse = {
    import FailoverShardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.FailoverShardResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.FailoverShardResponse.ReadOnly =
    zio.aws.memorydb.model.FailoverShardResponse.wrap(buildAwsValue())
}
object FailoverShardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.FailoverShardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.FailoverShardResponse =
      zio.aws.memorydb.model
        .FailoverShardResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.memorydb.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.FailoverShardResponse
  ) extends zio.aws.memorydb.model.FailoverShardResponse.ReadOnly {
    override val cluster: Optional[zio.aws.memorydb.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.memorydb.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.FailoverShardResponse
  ): zio.aws.memorydb.model.FailoverShardResponse.ReadOnly = new Wrapper(impl)
}
