package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAllowedNodeTypeUpdatesResponse(
    scaleUpNodeTypes: Optional[Iterable[String]] = Optional.Absent,
    scaleDownNodeTypes: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse = {
    import ListAllowedNodeTypeUpdatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse
      .builder()
      .optionallyWith(
        scaleUpNodeTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.scaleUpNodeTypes)
      .optionallyWith(
        scaleDownNodeTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.scaleDownNodeTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly =
    zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse
      .wrap(buildAwsValue())
}
object ListAllowedNodeTypeUpdatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse =
      zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse(
        scaleUpNodeTypes.map(value => value),
        scaleDownNodeTypes.map(value => value)
      )
    def scaleUpNodeTypes: Optional[List[String]]
    def scaleDownNodeTypes: Optional[List[String]]
    def getScaleUpNodeTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("scaleUpNodeTypes", scaleUpNodeTypes)
    def getScaleDownNodeTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("scaleDownNodeTypes", scaleDownNodeTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse
  ) extends zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly {
    override val scaleUpNodeTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scaleUpNodeTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val scaleDownNodeTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scaleDownNodeTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse
  ): zio.aws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly =
    new Wrapper(impl)
}
