package zio.aws.memorydb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.TStamp
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Node(
    name: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    createTime: Optional[TStamp] = Optional.Absent,
    endpoint: Optional[zio.aws.memorydb.model.Endpoint] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Node = {
    import Node.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Node
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(createTime.map(value => TStamp.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Node.ReadOnly =
    zio.aws.memorydb.model.Node.wrap(buildAwsValue())
}
object Node {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Node] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Node = zio.aws.memorydb.model.Node(
      name.map(value => value),
      status.map(value => value),
      availabilityZone.map(value => value),
      createTime.map(value => value),
      endpoint.map(value => value.asEditable)
    )
    def name: Optional[String]
    def status: Optional[String]
    def availabilityZone: Optional[String]
    def createTime: Optional[TStamp]
    def endpoint: Optional[zio.aws.memorydb.model.Endpoint.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getEndpoint
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Node
  ) extends zio.aws.memorydb.model.Node.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val createTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
    override val endpoint: Optional[zio.aws.memorydb.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.memorydb.model.Endpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Node
  ): zio.aws.memorydb.model.Node.ReadOnly = new Wrapper(impl)
}
