package zio.aws.memorydb.model
import scala.jdk.CollectionConverters._
sealed trait ServiceUpdateType {
  def unwrap: software.amazon.awssdk.services.memorydb.model.ServiceUpdateType
}
object ServiceUpdateType {
  def wrap(
      value: software.amazon.awssdk.services.memorydb.model.ServiceUpdateType
  ): zio.aws.memorydb.model.ServiceUpdateType = value match {
    case software.amazon.awssdk.services.memorydb.model.ServiceUpdateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.memorydb.model.ServiceUpdateType.SECURITY_UPDATE =>
      val r = `security-update`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.memorydb.model.ServiceUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.ServiceUpdateType =
      software.amazon.awssdk.services.memorydb.model.ServiceUpdateType.UNKNOWN_TO_SDK_VERSION
  }
  case object `security-update`
      extends zio.aws.memorydb.model.ServiceUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.ServiceUpdateType =
      software.amazon.awssdk.services.memorydb.model.ServiceUpdateType.SECURITY_UPDATE
  }
}
