package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ShardConfiguration(
    slots: Optional[String] = Optional.Absent,
    replicaCount: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ShardConfiguration = {
    import ShardConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ShardConfiguration
      .builder()
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(replicaCount.map(value => value: Integer))(_.replicaCount)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ShardConfiguration.ReadOnly =
    zio.aws.memorydb.model.ShardConfiguration.wrap(buildAwsValue())
}
object ShardConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ShardConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ShardConfiguration =
      zio.aws.memorydb.model.ShardConfiguration(
        slots.map(value => value),
        replicaCount.map(value => value)
      )
    def slots: Optional[String]
    def replicaCount: Optional[IntegerOptional]
    def getSlots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slots)
    def getReplicaCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("replicaCount", replicaCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfiguration
  ) extends zio.aws.memorydb.model.ShardConfiguration.ReadOnly {
    override val slots: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slots())
      .map(value => value: String)
    override val replicaCount: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaCount())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfiguration
  ): zio.aws.memorydb.model.ShardConfiguration.ReadOnly = new Wrapper(impl)
}
