package zio.aws.memorydb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.TStamp
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ShardDetail(
    name: Optional[String] = Optional.Absent,
    configuration: Optional[zio.aws.memorydb.model.ShardConfiguration] =
      Optional.Absent,
    size: Optional[String] = Optional.Absent,
    snapshotCreationTime: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ShardDetail = {
    import ShardDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ShardDetail
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(size.map(value => value: java.lang.String))(_.size)
      .optionallyWith(
        snapshotCreationTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotCreationTime)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ShardDetail.ReadOnly =
    zio.aws.memorydb.model.ShardDetail.wrap(buildAwsValue())
}
object ShardDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ShardDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ShardDetail =
      zio.aws.memorydb.model.ShardDetail(
        name.map(value => value),
        configuration.map(value => value.asEditable),
        size.map(value => value),
        snapshotCreationTime.map(value => value)
      )
    def name: Optional[String]
    def configuration
        : Optional[zio.aws.memorydb.model.ShardConfiguration.ReadOnly]
    def size: Optional[String]
    def snapshotCreationTime: Optional[TStamp]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.memorydb.model.ShardConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getSize: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("size", size)
    def getSnapshotCreationTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotCreationTime", snapshotCreationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ShardDetail
  ) extends zio.aws.memorydb.model.ShardDetail.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val configuration
        : Optional[zio.aws.memorydb.model.ShardConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.memorydb.model.ShardConfiguration.wrap(value))
    override val size: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: String)
    override val snapshotCreationTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotCreationTime())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ShardDetail
  ): zio.aws.memorydb.model.ShardDetail.ReadOnly = new Wrapper(impl)
}
