package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{PaginationToken, StrictlyPositiveInteger}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeJobsRequest(
    filters: Optional[zio.aws.mgn.model.DescribeJobsRequestFilters] =
      Optional.Absent,
    maxResults: Optional[StrictlyPositiveInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeJobsRequest = {
    import DescribeJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeJobsRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxResults.map(value => StrictlyPositiveInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeJobsRequest.ReadOnly =
    zio.aws.mgn.model.DescribeJobsRequest.wrap(buildAwsValue())
}
object DescribeJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeJobsRequest =
      zio.aws.mgn.model.DescribeJobsRequest(
        filters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly]
    def maxResults: Optional[StrictlyPositiveInteger]
    def nextToken: Optional[PaginationToken]
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobsRequest
  ) extends zio.aws.mgn.model.DescribeJobsRequest.ReadOnly {
    override val filters
        : Optional[zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value => zio.aws.mgn.model.DescribeJobsRequestFilters.wrap(value))
    override val maxResults: Optional[StrictlyPositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobsRequest
  ): zio.aws.mgn.model.DescribeJobsRequest.ReadOnly = new Wrapper(impl)
}
