package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class GetLaunchConfigurationRequest(sourceServerID: SourceServerID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationRequest = {
    import GetLaunchConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationRequest
      .builder()
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.GetLaunchConfigurationRequest.ReadOnly =
    zio.aws.mgn.model.GetLaunchConfigurationRequest.wrap(buildAwsValue())
}
object GetLaunchConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.GetLaunchConfigurationRequest =
      zio.aws.mgn.model.GetLaunchConfigurationRequest(sourceServerID)
    def sourceServerID: SourceServerID
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationRequest
  ) extends zio.aws.mgn.model.GetLaunchConfigurationRequest.ReadOnly {
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationRequest
  ): zio.aws.mgn.model.GetLaunchConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
