package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LifeCycleLastCutover(
    finalized: Optional[zio.aws.mgn.model.LifeCycleLastCutoverFinalized] =
      Optional.Absent,
    initiated: Optional[zio.aws.mgn.model.LifeCycleLastCutoverInitiated] =
      Optional.Absent,
    reverted: Optional[zio.aws.mgn.model.LifeCycleLastCutoverReverted] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.LifeCycleLastCutover = {
    import LifeCycleLastCutover.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LifeCycleLastCutover
      .builder()
      .optionallyWith(finalized.map(value => value.buildAwsValue()))(
        _.finalized
      )
      .optionallyWith(initiated.map(value => value.buildAwsValue()))(
        _.initiated
      )
      .optionallyWith(reverted.map(value => value.buildAwsValue()))(_.reverted)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LifeCycleLastCutover.ReadOnly =
    zio.aws.mgn.model.LifeCycleLastCutover.wrap(buildAwsValue())
}
object LifeCycleLastCutover {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.LifeCycleLastCutover
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LifeCycleLastCutover =
      zio.aws.mgn.model.LifeCycleLastCutover(
        finalized.map(value => value.asEditable),
        initiated.map(value => value.asEditable),
        reverted.map(value => value.asEditable)
      )
    def finalized
        : Optional[zio.aws.mgn.model.LifeCycleLastCutoverFinalized.ReadOnly]
    def initiated
        : Optional[zio.aws.mgn.model.LifeCycleLastCutoverInitiated.ReadOnly]
    def reverted
        : Optional[zio.aws.mgn.model.LifeCycleLastCutoverReverted.ReadOnly]
    def getFinalized: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LifeCycleLastCutoverFinalized.ReadOnly
    ] = AwsError.unwrapOptionField("finalized", finalized)
    def getInitiated: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LifeCycleLastCutoverInitiated.ReadOnly
    ] = AwsError.unwrapOptionField("initiated", initiated)
    def getReverted: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LifeCycleLastCutoverReverted.ReadOnly
    ] = AwsError.unwrapOptionField("reverted", reverted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastCutover
  ) extends zio.aws.mgn.model.LifeCycleLastCutover.ReadOnly {
    override val finalized
        : Optional[zio.aws.mgn.model.LifeCycleLastCutoverFinalized.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalized())
        .map(value =>
          zio.aws.mgn.model.LifeCycleLastCutoverFinalized.wrap(value)
        )
    override val initiated
        : Optional[zio.aws.mgn.model.LifeCycleLastCutoverInitiated.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiated())
        .map(value =>
          zio.aws.mgn.model.LifeCycleLastCutoverInitiated.wrap(value)
        )
    override val reverted
        : Optional[zio.aws.mgn.model.LifeCycleLastCutoverReverted.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reverted())
        .map(value =>
          zio.aws.mgn.model.LifeCycleLastCutoverReverted.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastCutover
  ): zio.aws.mgn.model.LifeCycleLastCutover.ReadOnly = new Wrapper(impl)
}
