package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class UpdateSourceServerReplicationTypeRequest(
    replicationType: zio.aws.mgn.model.ReplicationType,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeRequest = {
    import UpdateSourceServerReplicationTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeRequest
      .builder()
      .replicationType(replicationType.unwrap)
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.UpdateSourceServerReplicationTypeRequest.ReadOnly =
    zio.aws.mgn.model.UpdateSourceServerReplicationTypeRequest
      .wrap(buildAwsValue())
}
object UpdateSourceServerReplicationTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UpdateSourceServerReplicationTypeRequest =
      zio.aws.mgn.model.UpdateSourceServerReplicationTypeRequest(
        replicationType,
        sourceServerID
      )
    def replicationType: zio.aws.mgn.model.ReplicationType
    def sourceServerID: SourceServerID
    def getReplicationType
        : ZIO[Any, Nothing, zio.aws.mgn.model.ReplicationType] =
      ZIO.succeed(replicationType)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeRequest
  ) extends zio.aws.mgn.model.UpdateSourceServerReplicationTypeRequest.ReadOnly {
    override val replicationType: zio.aws.mgn.model.ReplicationType =
      zio.aws.mgn.model.ReplicationType.wrap(impl.replicationType())
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeRequest
  ): zio.aws.mgn.model.UpdateSourceServerReplicationTypeRequest.ReadOnly =
    new Wrapper(impl)
}
