package zio.aws.mgn
import software.amazon.awssdk.services.mgn.model.{
  DescribeReplicationConfigurationTemplatesRequest,
  DeleteVcenterClientResponse,
  CreateReplicationConfigurationTemplateRequest,
  DeleteVcenterClientRequest,
  StartReplicationResponse,
  DisconnectFromServiceRequest,
  UpdateSourceServerReplicationTypeRequest,
  FinalizeCutoverRequest,
  SourceServer,
  GetReplicationConfigurationRequest,
  CreateLaunchConfigurationTemplateRequest,
  StartTestResponse,
  UpdateLaunchConfigurationTemplateResponse,
  DescribeLaunchConfigurationTemplatesResponse,
  DescribeJobsResponse,
  DescribeLaunchConfigurationTemplatesRequest,
  UpdateLaunchConfigurationRequest,
  DeleteReplicationConfigurationTemplateRequest,
  StartReplicationRequest,
  ListTagsForResourceRequest,
  RetryDataReplicationRequest,
  TerminateTargetInstancesRequest,
  TerminateTargetInstancesResponse,
  DescribeJobsRequest,
  GetReplicationConfigurationResponse,
  MarkAsArchivedRequest,
  DeleteJobResponse,
  CreateReplicationConfigurationTemplateResponse,
  DeleteLaunchConfigurationTemplateResponse,
  UpdateLaunchConfigurationResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteJobRequest,
  DescribeSourceServersRequest,
  GetLaunchConfigurationRequest,
  JobLog,
  UpdateLaunchConfigurationTemplateRequest,
  RetryDataReplicationResponse,
  UpdateReplicationConfigurationTemplateResponse,
  UpdateReplicationConfigurationRequest,
  GetLaunchConfigurationResponse,
  DescribeJobLogItemsRequest,
  Job,
  StartCutoverResponse,
  InitializeServiceResponse,
  DescribeVcenterClientsResponse,
  CreateLaunchConfigurationTemplateResponse,
  MarkAsArchivedResponse,
  UntagResourceRequest,
  DeleteSourceServerRequest,
  DescribeReplicationConfigurationTemplatesResponse,
  UpdateSourceServerReplicationTypeResponse,
  StartCutoverRequest,
  FinalizeCutoverResponse,
  ChangeServerLifeCycleStateResponse,
  VcenterClient,
  DeleteReplicationConfigurationTemplateResponse,
  DescribeVcenterClientsRequest,
  UpdateReplicationConfigurationResponse,
  ChangeServerLifeCycleStateRequest,
  TagResourceResponse,
  DescribeJobLogItemsResponse,
  DisconnectFromServiceResponse,
  DeleteSourceServerResponse,
  StartTestRequest,
  DeleteLaunchConfigurationTemplateRequest,
  UpdateReplicationConfigurationTemplateRequest,
  ReplicationConfigurationTemplate,
  TagResourceRequest,
  LaunchConfigurationTemplate,
  InitializeServiceRequest,
  DescribeSourceServersResponse
}
import zio.aws.mgn.model.GetLaunchConfigurationResponse.ReadOnly
import software.amazon.awssdk.services.mgn.{
  MgnAsyncClientBuilder,
  MgnAsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.mgn.paginators.{
  DescribeVcenterClientsPublisher,
  DescribeJobsPublisher,
  DescribeReplicationConfigurationTemplatesPublisher,
  DescribeJobLogItemsPublisher,
  DescribeLaunchConfigurationTemplatesPublisher,
  DescribeSourceServersPublisher
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Mgn extends AspectSupport[Mgn] {
  val api: MgnAsyncClient
  def deleteSourceServer(
      request: zio.aws.mgn.model.DeleteSourceServerRequest
  ): IO[AwsError, zio.aws.mgn.model.DeleteSourceServerResponse.ReadOnly]
  def getLaunchConfiguration(
      request: zio.aws.mgn.model.GetLaunchConfigurationRequest
  ): IO[AwsError, ReadOnly]
  def updateReplicationConfigurationTemplate(
      request: zio.aws.mgn.model.UpdateReplicationConfigurationTemplateRequest
  ): IO[
    AwsError,
    zio.aws.mgn.model.UpdateReplicationConfigurationTemplateResponse.ReadOnly
  ]
  def terminateTargetInstances(
      request: zio.aws.mgn.model.TerminateTargetInstancesRequest
  ): IO[AwsError, zio.aws.mgn.model.TerminateTargetInstancesResponse.ReadOnly]
  def markAsArchived(
      request: zio.aws.mgn.model.MarkAsArchivedRequest
  ): IO[AwsError, zio.aws.mgn.model.MarkAsArchivedResponse.ReadOnly]
  def describeVcenterClients(
      request: zio.aws.mgn.model.DescribeVcenterClientsRequest
  ): ZStream[Any, AwsError, zio.aws.mgn.model.VcenterClient.ReadOnly]
  def describeVcenterClientsPaginated(
      request: zio.aws.mgn.model.DescribeVcenterClientsRequest
  ): IO[AwsError, zio.aws.mgn.model.DescribeVcenterClientsResponse.ReadOnly]
  def describeReplicationConfigurationTemplates(
      request: zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.mgn.model.ReplicationConfigurationTemplate.ReadOnly
  ]
  def describeReplicationConfigurationTemplatesPaginated(
      request: zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest
  ): IO[
    AwsError,
    zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse.ReadOnly
  ]
  def startCutover(
      request: zio.aws.mgn.model.StartCutoverRequest
  ): IO[AwsError, zio.aws.mgn.model.StartCutoverResponse.ReadOnly]
  def initializeService(
      request: zio.aws.mgn.model.InitializeServiceRequest
  ): IO[AwsError, zio.aws.mgn.model.InitializeServiceResponse.ReadOnly]
  def getReplicationConfiguration(
      request: zio.aws.mgn.model.GetReplicationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.mgn.model.GetReplicationConfigurationResponse.ReadOnly
  ]
  def updateLaunchConfigurationTemplate(
      request: zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest
  ): IO[
    AwsError,
    zio.aws.mgn.model.UpdateLaunchConfigurationTemplateResponse.ReadOnly
  ]
  def startReplication(
      request: zio.aws.mgn.model.StartReplicationRequest
  ): IO[AwsError, zio.aws.mgn.model.StartReplicationResponse.ReadOnly]
  def describeJobLogItems(
      request: zio.aws.mgn.model.DescribeJobLogItemsRequest
  ): ZStream[Any, AwsError, zio.aws.mgn.model.JobLog.ReadOnly]
  def describeJobLogItemsPaginated(
      request: zio.aws.mgn.model.DescribeJobLogItemsRequest
  ): IO[AwsError, zio.aws.mgn.model.DescribeJobLogItemsResponse.ReadOnly]
  def updateSourceServerReplicationType(
      request: zio.aws.mgn.model.UpdateSourceServerReplicationTypeRequest
  ): IO[
    AwsError,
    zio.aws.mgn.model.UpdateSourceServerReplicationTypeResponse.ReadOnly
  ]
  def deleteVcenterClient(
      request: zio.aws.mgn.model.DeleteVcenterClientRequest
  ): IO[AwsError, Unit]
  def disconnectFromService(
      request: zio.aws.mgn.model.DisconnectFromServiceRequest
  ): IO[AwsError, zio.aws.mgn.model.DisconnectFromServiceResponse.ReadOnly]
  def describeJobs(
      request: zio.aws.mgn.model.DescribeJobsRequest
  ): ZStream[Any, AwsError, zio.aws.mgn.model.Job.ReadOnly]
  def describeJobsPaginated(
      request: zio.aws.mgn.model.DescribeJobsRequest
  ): IO[AwsError, zio.aws.mgn.model.DescribeJobsResponse.ReadOnly]
  def createReplicationConfigurationTemplate(
      request: zio.aws.mgn.model.CreateReplicationConfigurationTemplateRequest
  ): IO[
    AwsError,
    zio.aws.mgn.model.CreateReplicationConfigurationTemplateResponse.ReadOnly
  ]
  def deleteLaunchConfigurationTemplate(
      request: zio.aws.mgn.model.DeleteLaunchConfigurationTemplateRequest
  ): IO[
    AwsError,
    zio.aws.mgn.model.DeleteLaunchConfigurationTemplateResponse.ReadOnly
  ]
  def updateLaunchConfiguration(
      request: zio.aws.mgn.model.UpdateLaunchConfigurationRequest
  ): IO[AwsError, zio.aws.mgn.model.UpdateLaunchConfigurationResponse.ReadOnly]
  def updateReplicationConfiguration(
      request: zio.aws.mgn.model.UpdateReplicationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.mgn.model.UpdateReplicationConfigurationResponse.ReadOnly
  ]
  def describeSourceServers(
      request: zio.aws.mgn.model.DescribeSourceServersRequest
  ): ZStream[Any, AwsError, zio.aws.mgn.model.SourceServer.ReadOnly]
  def describeSourceServersPaginated(
      request: zio.aws.mgn.model.DescribeSourceServersRequest
  ): IO[AwsError, zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly]
  def untagResource(
      request: zio.aws.mgn.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def deleteReplicationConfigurationTemplate(
      request: zio.aws.mgn.model.DeleteReplicationConfigurationTemplateRequest
  ): IO[
    AwsError,
    zio.aws.mgn.model.DeleteReplicationConfigurationTemplateResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.mgn.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.mgn.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.mgn.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def createLaunchConfigurationTemplate(
      request: zio.aws.mgn.model.CreateLaunchConfigurationTemplateRequest
  ): IO[
    AwsError,
    zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse.ReadOnly
  ]
  def finalizeCutover(
      request: zio.aws.mgn.model.FinalizeCutoverRequest
  ): IO[AwsError, zio.aws.mgn.model.FinalizeCutoverResponse.ReadOnly]
  def describeLaunchConfigurationTemplates(
      request: zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.mgn.model.LaunchConfigurationTemplate.ReadOnly
  ]
  def describeLaunchConfigurationTemplatesPaginated(
      request: zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest
  ): IO[
    AwsError,
    zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesResponse.ReadOnly
  ]
  def retryDataReplication(
      request: zio.aws.mgn.model.RetryDataReplicationRequest
  ): IO[AwsError, zio.aws.mgn.model.RetryDataReplicationResponse.ReadOnly]
  def changeServerLifeCycleState(
      request: zio.aws.mgn.model.ChangeServerLifeCycleStateRequest
  ): IO[AwsError, zio.aws.mgn.model.ChangeServerLifeCycleStateResponse.ReadOnly]
  def startTest(
      request: zio.aws.mgn.model.StartTestRequest
  ): IO[AwsError, zio.aws.mgn.model.StartTestResponse.ReadOnly]
  def deleteJob(
      request: zio.aws.mgn.model.DeleteJobRequest
  ): IO[AwsError, zio.aws.mgn.model.DeleteJobResponse.ReadOnly]
}
object Mgn {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Mgn] = customized(identity)
  def customized(
      customization: MgnAsyncClientBuilder => MgnAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Mgn] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: MgnAsyncClientBuilder => MgnAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Mgn] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = MgnAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[MgnAsyncClient, MgnAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[MgnAsyncClient, MgnAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new MgnImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class MgnImpl[R](
      override val api: MgnAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Mgn
      with AwsServiceBase[R] {
    override val serviceName: String = "Mgn"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MgnImpl[R1] = new MgnImpl(api, newAspect, r)
    def deleteSourceServer(
        request: zio.aws.mgn.model.DeleteSourceServerRequest
    ): IO[AwsError, zio.aws.mgn.model.DeleteSourceServerResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteSourceServerRequest,
        DeleteSourceServerResponse
      ]("deleteSourceServer", api.deleteSourceServer)(request.buildAwsValue())
        .map(zio.aws.mgn.model.DeleteSourceServerResponse.wrap)
        .provideEnvironment(r)
    def getLaunchConfiguration(
        request: zio.aws.mgn.model.GetLaunchConfigurationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      GetLaunchConfigurationRequest,
      GetLaunchConfigurationResponse
    ]("getLaunchConfiguration", api.getLaunchConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.mgn.model.GetLaunchConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateReplicationConfigurationTemplate(
        request: zio.aws.mgn.model.UpdateReplicationConfigurationTemplateRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.UpdateReplicationConfigurationTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateReplicationConfigurationTemplateRequest,
      UpdateReplicationConfigurationTemplateResponse
    ](
      "updateReplicationConfigurationTemplate",
      api.updateReplicationConfigurationTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.mgn.model.UpdateReplicationConfigurationTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def terminateTargetInstances(
        request: zio.aws.mgn.model.TerminateTargetInstancesRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.TerminateTargetInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      TerminateTargetInstancesRequest,
      TerminateTargetInstancesResponse
    ]("terminateTargetInstances", api.terminateTargetInstances)(
      request.buildAwsValue()
    ).map(zio.aws.mgn.model.TerminateTargetInstancesResponse.wrap)
      .provideEnvironment(r)
    def markAsArchived(
        request: zio.aws.mgn.model.MarkAsArchivedRequest
    ): IO[AwsError, zio.aws.mgn.model.MarkAsArchivedResponse.ReadOnly] =
      asyncRequestResponse[MarkAsArchivedRequest, MarkAsArchivedResponse](
        "markAsArchived",
        api.markAsArchived
      )(request.buildAwsValue())
        .map(zio.aws.mgn.model.MarkAsArchivedResponse.wrap)
        .provideEnvironment(r)
    def describeVcenterClients(
        request: zio.aws.mgn.model.DescribeVcenterClientsRequest
    ): ZStream[Any, AwsError, zio.aws.mgn.model.VcenterClient.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeVcenterClientsRequest,
        VcenterClient,
        DescribeVcenterClientsPublisher
      ](
        "describeVcenterClients",
        api.describeVcenterClientsPaginator,
        _.items()
      )(request.buildAwsValue())
        .map(item => zio.aws.mgn.model.VcenterClient.wrap(item))
        .provideEnvironment(r)
    def describeVcenterClientsPaginated(
        request: zio.aws.mgn.model.DescribeVcenterClientsRequest
    ): IO[AwsError, zio.aws.mgn.model.DescribeVcenterClientsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeVcenterClientsRequest,
        DescribeVcenterClientsResponse
      ]("describeVcenterClients", api.describeVcenterClients)(
        request.buildAwsValue()
      ).map(zio.aws.mgn.model.DescribeVcenterClientsResponse.wrap)
        .provideEnvironment(r)
    def describeReplicationConfigurationTemplates(
        request: zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.mgn.model.ReplicationConfigurationTemplate.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribeReplicationConfigurationTemplatesRequest,
      ReplicationConfigurationTemplate,
      DescribeReplicationConfigurationTemplatesPublisher
    ](
      "describeReplicationConfigurationTemplates",
      api.describeReplicationConfigurationTemplatesPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.mgn.model.ReplicationConfigurationTemplate.wrap(item)
      )
      .provideEnvironment(r)
    def describeReplicationConfigurationTemplatesPaginated(
        request: zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationConfigurationTemplatesRequest,
      DescribeReplicationConfigurationTemplatesResponse
    ](
      "describeReplicationConfigurationTemplates",
      api.describeReplicationConfigurationTemplates
    )(request.buildAwsValue())
      .map(
        zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse.wrap
      )
      .provideEnvironment(r)
    def startCutover(
        request: zio.aws.mgn.model.StartCutoverRequest
    ): IO[AwsError, zio.aws.mgn.model.StartCutoverResponse.ReadOnly] =
      asyncRequestResponse[StartCutoverRequest, StartCutoverResponse](
        "startCutover",
        api.startCutover
      )(request.buildAwsValue())
        .map(zio.aws.mgn.model.StartCutoverResponse.wrap)
        .provideEnvironment(r)
    def initializeService(
        request: zio.aws.mgn.model.InitializeServiceRequest
    ): IO[AwsError, zio.aws.mgn.model.InitializeServiceResponse.ReadOnly] =
      asyncRequestResponse[InitializeServiceRequest, InitializeServiceResponse](
        "initializeService",
        api.initializeService
      )(request.buildAwsValue())
        .map(zio.aws.mgn.model.InitializeServiceResponse.wrap)
        .provideEnvironment(r)
    def getReplicationConfiguration(
        request: zio.aws.mgn.model.GetReplicationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.GetReplicationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetReplicationConfigurationRequest,
      GetReplicationConfigurationResponse
    ]("getReplicationConfiguration", api.getReplicationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.mgn.model.GetReplicationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateLaunchConfigurationTemplate(
        request: zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.UpdateLaunchConfigurationTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateLaunchConfigurationTemplateRequest,
      UpdateLaunchConfigurationTemplateResponse
    ](
      "updateLaunchConfigurationTemplate",
      api.updateLaunchConfigurationTemplate
    )(request.buildAwsValue())
      .map(zio.aws.mgn.model.UpdateLaunchConfigurationTemplateResponse.wrap)
      .provideEnvironment(r)
    def startReplication(
        request: zio.aws.mgn.model.StartReplicationRequest
    ): IO[AwsError, zio.aws.mgn.model.StartReplicationResponse.ReadOnly] =
      asyncRequestResponse[StartReplicationRequest, StartReplicationResponse](
        "startReplication",
        api.startReplication
      )(request.buildAwsValue())
        .map(zio.aws.mgn.model.StartReplicationResponse.wrap)
        .provideEnvironment(r)
    def describeJobLogItems(
        request: zio.aws.mgn.model.DescribeJobLogItemsRequest
    ): ZStream[Any, AwsError, zio.aws.mgn.model.JobLog.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeJobLogItemsRequest,
        JobLog,
        DescribeJobLogItemsPublisher
      ]("describeJobLogItems", api.describeJobLogItemsPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.mgn.model.JobLog.wrap(item)).provideEnvironment(r)
    def describeJobLogItemsPaginated(
        request: zio.aws.mgn.model.DescribeJobLogItemsRequest
    ): IO[AwsError, zio.aws.mgn.model.DescribeJobLogItemsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeJobLogItemsRequest,
        DescribeJobLogItemsResponse
      ]("describeJobLogItems", api.describeJobLogItems)(request.buildAwsValue())
        .map(zio.aws.mgn.model.DescribeJobLogItemsResponse.wrap)
        .provideEnvironment(r)
    def updateSourceServerReplicationType(
        request: zio.aws.mgn.model.UpdateSourceServerReplicationTypeRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.UpdateSourceServerReplicationTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSourceServerReplicationTypeRequest,
      UpdateSourceServerReplicationTypeResponse
    ](
      "updateSourceServerReplicationType",
      api.updateSourceServerReplicationType
    )(request.buildAwsValue())
      .map(zio.aws.mgn.model.UpdateSourceServerReplicationTypeResponse.wrap)
      .provideEnvironment(r)
    def deleteVcenterClient(
        request: zio.aws.mgn.model.DeleteVcenterClientRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteVcenterClientRequest,
      DeleteVcenterClientResponse
    ]("deleteVcenterClient", api.deleteVcenterClient)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def disconnectFromService(
        request: zio.aws.mgn.model.DisconnectFromServiceRequest
    ): IO[AwsError, zio.aws.mgn.model.DisconnectFromServiceResponse.ReadOnly] =
      asyncRequestResponse[
        DisconnectFromServiceRequest,
        DisconnectFromServiceResponse
      ]("disconnectFromService", api.disconnectFromService)(
        request.buildAwsValue()
      ).map(zio.aws.mgn.model.DisconnectFromServiceResponse.wrap)
        .provideEnvironment(r)
    def describeJobs(
        request: zio.aws.mgn.model.DescribeJobsRequest
    ): ZStream[Any, AwsError, zio.aws.mgn.model.Job.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeJobsRequest,
        Job,
        DescribeJobsPublisher
      ]("describeJobs", api.describeJobsPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.mgn.model.Job.wrap(item)).provideEnvironment(r)
    def describeJobsPaginated(
        request: zio.aws.mgn.model.DescribeJobsRequest
    ): IO[AwsError, zio.aws.mgn.model.DescribeJobsResponse.ReadOnly] =
      asyncRequestResponse[DescribeJobsRequest, DescribeJobsResponse](
        "describeJobs",
        api.describeJobs
      )(request.buildAwsValue())
        .map(zio.aws.mgn.model.DescribeJobsResponse.wrap)
        .provideEnvironment(r)
    def createReplicationConfigurationTemplate(
        request: zio.aws.mgn.model.CreateReplicationConfigurationTemplateRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.CreateReplicationConfigurationTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateReplicationConfigurationTemplateRequest,
      CreateReplicationConfigurationTemplateResponse
    ](
      "createReplicationConfigurationTemplate",
      api.createReplicationConfigurationTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.mgn.model.CreateReplicationConfigurationTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def deleteLaunchConfigurationTemplate(
        request: zio.aws.mgn.model.DeleteLaunchConfigurationTemplateRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.DeleteLaunchConfigurationTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteLaunchConfigurationTemplateRequest,
      DeleteLaunchConfigurationTemplateResponse
    ](
      "deleteLaunchConfigurationTemplate",
      api.deleteLaunchConfigurationTemplate
    )(request.buildAwsValue())
      .map(zio.aws.mgn.model.DeleteLaunchConfigurationTemplateResponse.wrap)
      .provideEnvironment(r)
    def updateLaunchConfiguration(
        request: zio.aws.mgn.model.UpdateLaunchConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.UpdateLaunchConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateLaunchConfigurationRequest,
      UpdateLaunchConfigurationResponse
    ]("updateLaunchConfiguration", api.updateLaunchConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.mgn.model.UpdateLaunchConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateReplicationConfiguration(
        request: zio.aws.mgn.model.UpdateReplicationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.UpdateReplicationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateReplicationConfigurationRequest,
      UpdateReplicationConfigurationResponse
    ]("updateReplicationConfiguration", api.updateReplicationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.mgn.model.UpdateReplicationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeSourceServers(
        request: zio.aws.mgn.model.DescribeSourceServersRequest
    ): ZStream[Any, AwsError, zio.aws.mgn.model.SourceServer.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeSourceServersRequest,
        SourceServer,
        DescribeSourceServersPublisher
      ]("describeSourceServers", api.describeSourceServersPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.mgn.model.SourceServer.wrap(item))
        .provideEnvironment(r)
    def describeSourceServersPaginated(
        request: zio.aws.mgn.model.DescribeSourceServersRequest
    ): IO[AwsError, zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeSourceServersRequest,
        DescribeSourceServersResponse
      ]("describeSourceServers", api.describeSourceServers)(
        request.buildAwsValue()
      ).map(zio.aws.mgn.model.DescribeSourceServersResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.mgn.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteReplicationConfigurationTemplate(
        request: zio.aws.mgn.model.DeleteReplicationConfigurationTemplateRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.DeleteReplicationConfigurationTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteReplicationConfigurationTemplateRequest,
      DeleteReplicationConfigurationTemplateResponse
    ](
      "deleteReplicationConfigurationTemplate",
      api.deleteReplicationConfigurationTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.mgn.model.DeleteReplicationConfigurationTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.mgn.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.mgn.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.mgn.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.mgn.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createLaunchConfigurationTemplate(
        request: zio.aws.mgn.model.CreateLaunchConfigurationTemplateRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateLaunchConfigurationTemplateRequest,
      CreateLaunchConfigurationTemplateResponse
    ](
      "createLaunchConfigurationTemplate",
      api.createLaunchConfigurationTemplate
    )(request.buildAwsValue())
      .map(zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse.wrap)
      .provideEnvironment(r)
    def finalizeCutover(
        request: zio.aws.mgn.model.FinalizeCutoverRequest
    ): IO[AwsError, zio.aws.mgn.model.FinalizeCutoverResponse.ReadOnly] =
      asyncRequestResponse[FinalizeCutoverRequest, FinalizeCutoverResponse](
        "finalizeCutover",
        api.finalizeCutover
      )(request.buildAwsValue())
        .map(zio.aws.mgn.model.FinalizeCutoverResponse.wrap)
        .provideEnvironment(r)
    def describeLaunchConfigurationTemplates(
        request: zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.mgn.model.LaunchConfigurationTemplate.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribeLaunchConfigurationTemplatesRequest,
      LaunchConfigurationTemplate,
      DescribeLaunchConfigurationTemplatesPublisher
    ](
      "describeLaunchConfigurationTemplates",
      api.describeLaunchConfigurationTemplatesPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item => zio.aws.mgn.model.LaunchConfigurationTemplate.wrap(item))
      .provideEnvironment(r)
    def describeLaunchConfigurationTemplatesPaginated(
        request: zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLaunchConfigurationTemplatesRequest,
      DescribeLaunchConfigurationTemplatesResponse
    ](
      "describeLaunchConfigurationTemplates",
      api.describeLaunchConfigurationTemplates
    )(request.buildAwsValue())
      .map(zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesResponse.wrap)
      .provideEnvironment(r)
    def retryDataReplication(
        request: zio.aws.mgn.model.RetryDataReplicationRequest
    ): IO[AwsError, zio.aws.mgn.model.RetryDataReplicationResponse.ReadOnly] =
      asyncRequestResponse[
        RetryDataReplicationRequest,
        RetryDataReplicationResponse
      ]("retryDataReplication", api.retryDataReplication)(
        request.buildAwsValue()
      ).map(zio.aws.mgn.model.RetryDataReplicationResponse.wrap)
        .provideEnvironment(r)
    def changeServerLifeCycleState(
        request: zio.aws.mgn.model.ChangeServerLifeCycleStateRequest
    ): IO[
      AwsError,
      zio.aws.mgn.model.ChangeServerLifeCycleStateResponse.ReadOnly
    ] = asyncRequestResponse[
      ChangeServerLifeCycleStateRequest,
      ChangeServerLifeCycleStateResponse
    ]("changeServerLifeCycleState", api.changeServerLifeCycleState)(
      request.buildAwsValue()
    ).map(zio.aws.mgn.model.ChangeServerLifeCycleStateResponse.wrap)
      .provideEnvironment(r)
    def startTest(
        request: zio.aws.mgn.model.StartTestRequest
    ): IO[AwsError, zio.aws.mgn.model.StartTestResponse.ReadOnly] =
      asyncRequestResponse[StartTestRequest, StartTestResponse](
        "startTest",
        api.startTest
      )(request.buildAwsValue())
        .map(zio.aws.mgn.model.StartTestResponse.wrap)
        .provideEnvironment(r)
    def deleteJob(
        request: zio.aws.mgn.model.DeleteJobRequest
    ): IO[AwsError, zio.aws.mgn.model.DeleteJobResponse.ReadOnly] =
      asyncRequestResponse[DeleteJobRequest, DeleteJobResponse](
        "deleteJob",
        api.deleteJob
      )(request.buildAwsValue())
        .map(zio.aws.mgn.model.DeleteJobResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteSourceServer(
      request: zio.aws.mgn.model.DeleteSourceServerRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.DeleteSourceServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSourceServer(request))
  def getLaunchConfiguration(
      request: zio.aws.mgn.model.GetLaunchConfigurationRequest
  ): ZIO[zio.aws.mgn.Mgn, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getLaunchConfiguration(request))
  def updateReplicationConfigurationTemplate(
      request: zio.aws.mgn.model.UpdateReplicationConfigurationTemplateRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.UpdateReplicationConfigurationTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateReplicationConfigurationTemplate(request))
  def terminateTargetInstances(
      request: zio.aws.mgn.model.TerminateTargetInstancesRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.TerminateTargetInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.terminateTargetInstances(request))
  def markAsArchived(request: zio.aws.mgn.model.MarkAsArchivedRequest): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.MarkAsArchivedResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.markAsArchived(request))
  def describeVcenterClients(
      request: zio.aws.mgn.model.DescribeVcenterClientsRequest
  ): ZStream[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.VcenterClient.ReadOnly
  ] = ZStream.serviceWithStream(_.describeVcenterClients(request))
  def describeVcenterClientsPaginated(
      request: zio.aws.mgn.model.DescribeVcenterClientsRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.DescribeVcenterClientsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVcenterClientsPaginated(request))
  def describeReplicationConfigurationTemplates(
      request: zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest
  ): ZStream[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.ReplicationConfigurationTemplate.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeReplicationConfigurationTemplates(request)
  )
  def describeReplicationConfigurationTemplatesPaginated(
      request: zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeReplicationConfigurationTemplatesPaginated(request)
  )
  def startCutover(request: zio.aws.mgn.model.StartCutoverRequest): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.StartCutoverResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startCutover(request))
  def initializeService(
      request: zio.aws.mgn.model.InitializeServiceRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.InitializeServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.initializeService(request))
  def getReplicationConfiguration(
      request: zio.aws.mgn.model.GetReplicationConfigurationRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.GetReplicationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReplicationConfiguration(request))
  def updateLaunchConfigurationTemplate(
      request: zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.UpdateLaunchConfigurationTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLaunchConfigurationTemplate(request))
  def startReplication(request: zio.aws.mgn.model.StartReplicationRequest): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.StartReplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReplication(request))
  def describeJobLogItems(
      request: zio.aws.mgn.model.DescribeJobLogItemsRequest
  ): ZStream[zio.aws.mgn.Mgn, AwsError, zio.aws.mgn.model.JobLog.ReadOnly] =
    ZStream.serviceWithStream(_.describeJobLogItems(request))
  def describeJobLogItemsPaginated(
      request: zio.aws.mgn.model.DescribeJobLogItemsRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.DescribeJobLogItemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJobLogItemsPaginated(request))
  def updateSourceServerReplicationType(
      request: zio.aws.mgn.model.UpdateSourceServerReplicationTypeRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.UpdateSourceServerReplicationTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSourceServerReplicationType(request))
  def deleteVcenterClient(
      request: zio.aws.mgn.model.DeleteVcenterClientRequest
  ): ZIO[zio.aws.mgn.Mgn, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVcenterClient(request))
  def disconnectFromService(
      request: zio.aws.mgn.model.DisconnectFromServiceRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.DisconnectFromServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disconnectFromService(request))
  def describeJobs(
      request: zio.aws.mgn.model.DescribeJobsRequest
  ): ZStream[zio.aws.mgn.Mgn, AwsError, zio.aws.mgn.model.Job.ReadOnly] =
    ZStream.serviceWithStream(_.describeJobs(request))
  def describeJobsPaginated(
      request: zio.aws.mgn.model.DescribeJobsRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.DescribeJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJobsPaginated(request))
  def createReplicationConfigurationTemplate(
      request: zio.aws.mgn.model.CreateReplicationConfigurationTemplateRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.CreateReplicationConfigurationTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplicationConfigurationTemplate(request))
  def deleteLaunchConfigurationTemplate(
      request: zio.aws.mgn.model.DeleteLaunchConfigurationTemplateRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.DeleteLaunchConfigurationTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLaunchConfigurationTemplate(request))
  def updateLaunchConfiguration(
      request: zio.aws.mgn.model.UpdateLaunchConfigurationRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.UpdateLaunchConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLaunchConfiguration(request))
  def updateReplicationConfiguration(
      request: zio.aws.mgn.model.UpdateReplicationConfigurationRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.UpdateReplicationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateReplicationConfiguration(request))
  def describeSourceServers(
      request: zio.aws.mgn.model.DescribeSourceServersRequest
  ): ZStream[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.SourceServer.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSourceServers(request))
  def describeSourceServersPaginated(
      request: zio.aws.mgn.model.DescribeSourceServersRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSourceServersPaginated(request))
  def untagResource(
      request: zio.aws.mgn.model.UntagResourceRequest
  ): ZIO[zio.aws.mgn.Mgn, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def deleteReplicationConfigurationTemplate(
      request: zio.aws.mgn.model.DeleteReplicationConfigurationTemplateRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.DeleteReplicationConfigurationTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationConfigurationTemplate(request))
  def listTagsForResource(
      request: zio.aws.mgn.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: zio.aws.mgn.model.TagResourceRequest
  ): ZIO[zio.aws.mgn.Mgn, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def createLaunchConfigurationTemplate(
      request: zio.aws.mgn.model.CreateLaunchConfigurationTemplateRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.CreateLaunchConfigurationTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLaunchConfigurationTemplate(request))
  def finalizeCutover(request: zio.aws.mgn.model.FinalizeCutoverRequest): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.FinalizeCutoverResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.finalizeCutover(request))
  def describeLaunchConfigurationTemplates(
      request: zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest
  ): ZStream[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.LaunchConfigurationTemplate.ReadOnly
  ] = ZStream.serviceWithStream(_.describeLaunchConfigurationTemplates(request))
  def describeLaunchConfigurationTemplatesPaginated(
      request: zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.DescribeLaunchConfigurationTemplatesResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeLaunchConfigurationTemplatesPaginated(request))
  def retryDataReplication(
      request: zio.aws.mgn.model.RetryDataReplicationRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.RetryDataReplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.retryDataReplication(request))
  def changeServerLifeCycleState(
      request: zio.aws.mgn.model.ChangeServerLifeCycleStateRequest
  ): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.ChangeServerLifeCycleStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.changeServerLifeCycleState(request))
  def startTest(request: zio.aws.mgn.model.StartTestRequest): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.StartTestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startTest(request))
  def deleteJob(request: zio.aws.mgn.model.DeleteJobRequest): ZIO[
    zio.aws.mgn.Mgn,
    AwsError,
    zio.aws.mgn.model.DeleteJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteJob(request))
}
