package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataReplicationInitiationStep(
    name: Optional[zio.aws.mgn.model.DataReplicationInitiationStepName] =
      Optional.Absent,
    status: Optional[zio.aws.mgn.model.DataReplicationInitiationStepStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DataReplicationInitiationStep = {
    import DataReplicationInitiationStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DataReplicationInitiationStep
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DataReplicationInitiationStep.ReadOnly =
    zio.aws.mgn.model.DataReplicationInitiationStep.wrap(buildAwsValue())
}
object DataReplicationInitiationStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DataReplicationInitiationStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DataReplicationInitiationStep =
      zio.aws.mgn.model.DataReplicationInitiationStep(
        name.map(value => value),
        status.map(value => value)
      )
    def name: Optional[zio.aws.mgn.model.DataReplicationInitiationStepName]
    def status: Optional[zio.aws.mgn.model.DataReplicationInitiationStepStatus]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.DataReplicationInitiationStepName
    ] = AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.DataReplicationInitiationStepStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInitiationStep
  ) extends zio.aws.mgn.model.DataReplicationInitiationStep.ReadOnly {
    override val name
        : Optional[zio.aws.mgn.model.DataReplicationInitiationStepName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.mgn.model.DataReplicationInitiationStepName.wrap(value)
        )
    override val status
        : Optional[zio.aws.mgn.model.DataReplicationInitiationStepStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.mgn.model.DataReplicationInitiationStepStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInitiationStep
  ): zio.aws.mgn.model.DataReplicationInitiationStep.ReadOnly = new Wrapper(
    impl
  )
}
