package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait LaunchStatus {
  def unwrap: software.amazon.awssdk.services.mgn.model.LaunchStatus
}
object LaunchStatus {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.LaunchStatus
  ): zio.aws.mgn.model.LaunchStatus = value match {
    case software.amazon.awssdk.services.mgn.model.LaunchStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.LaunchStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.mgn.model.LaunchStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.mgn.model.LaunchStatus.LAUNCHED =>
      val r = LAUNCHED
      r
    case software.amazon.awssdk.services.mgn.model.LaunchStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.mgn.model.LaunchStatus.TERMINATED =>
      val r = TERMINATED
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LaunchStatus =
      software.amazon.awssdk.services.mgn.model.LaunchStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.mgn.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LaunchStatus =
      software.amazon.awssdk.services.mgn.model.LaunchStatus.PENDING
  }
  case object IN_PROGRESS extends zio.aws.mgn.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LaunchStatus =
      software.amazon.awssdk.services.mgn.model.LaunchStatus.IN_PROGRESS
  }
  case object LAUNCHED extends zio.aws.mgn.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LaunchStatus =
      software.amazon.awssdk.services.mgn.model.LaunchStatus.LAUNCHED
  }
  case object FAILED extends zio.aws.mgn.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LaunchStatus =
      software.amazon.awssdk.services.mgn.model.LaunchStatus.FAILED
  }
  case object TERMINATED extends zio.aws.mgn.model.LaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LaunchStatus =
      software.amazon.awssdk.services.mgn.model.LaunchStatus.TERMINATED
  }
}
