package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait ReplicationType {
  def unwrap: software.amazon.awssdk.services.mgn.model.ReplicationType
}
object ReplicationType {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.ReplicationType
  ): zio.aws.mgn.model.ReplicationType = value match {
    case software.amazon.awssdk.services.mgn.model.ReplicationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.ReplicationType.AGENT_BASED =>
      val r = AGENT_BASED
      r
    case software.amazon.awssdk.services.mgn.model.ReplicationType.SNAPSHOT_SHIPPING =>
      val r = SNAPSHOT_SHIPPING
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.ReplicationType {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ReplicationType =
      software.amazon.awssdk.services.mgn.model.ReplicationType.UNKNOWN_TO_SDK_VERSION
  }
  case object AGENT_BASED extends zio.aws.mgn.model.ReplicationType {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ReplicationType =
      software.amazon.awssdk.services.mgn.model.ReplicationType.AGENT_BASED
  }
  case object SNAPSHOT_SHIPPING extends zio.aws.mgn.model.ReplicationType {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.ReplicationType =
      software.amazon.awssdk.services.mgn.model.ReplicationType.SNAPSHOT_SHIPPING
  }
}
