package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class StartReplicationRequest(sourceServerID: SourceServerID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.StartReplicationRequest = {
    import StartReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.StartReplicationRequest
      .builder()
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.StartReplicationRequest.ReadOnly =
    zio.aws.mgn.model.StartReplicationRequest.wrap(buildAwsValue())
}
object StartReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.StartReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.StartReplicationRequest =
      zio.aws.mgn.model.StartReplicationRequest(sourceServerID)
    def sourceServerID: SourceServerID
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.StartReplicationRequest
  ) extends zio.aws.mgn.model.StartReplicationRequest.ReadOnly {
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.StartReplicationRequest
  ): zio.aws.mgn.model.StartReplicationRequest.ReadOnly = new Wrapper(impl)
}
