package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.{TagKey, ARN}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: ARN,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UntagResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UntagResourceRequest.ReadOnly =
    zio.aws.mgn.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UntagResourceRequest =
      zio.aws.mgn.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ARN
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UntagResourceRequest
  ) extends zio.aws.mgn.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.mgn.model.primitives.ARN(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.mgn.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UntagResourceRequest
  ): zio.aws.mgn.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
