package zio.aws.mgn
import zio.prelude.Subtype
import zio.aws.mgn.model.primitives.{
  SecurityGroupID,
  BoundedString,
  JobID,
  TagValue,
  SsmDocumentParameterName,
  ReplicationConfigurationTemplateID,
  SourceServerID,
  LaunchConfigurationTemplateID,
  TagKey
}
import zio.aws.mgn.model.primitives.ISO8601DurationString.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ARN extends Subtype[String]
    type ARN = zio.aws.mgn.model.primitives.ARN.Type
    object BoundedString extends Subtype[String]
    type BoundedString = zio.aws.mgn.model.primitives.BoundedString.Type
    object CloudWatchLogGroupName extends Subtype[String]
    type CloudWatchLogGroupName =
      zio.aws.mgn.model.primitives.CloudWatchLogGroupName.Type
    object EC2InstanceID extends Subtype[String]
    type EC2InstanceID = zio.aws.mgn.model.primitives.EC2InstanceID.Type
    object EC2InstanceType extends Subtype[String]
    type EC2InstanceType = zio.aws.mgn.model.primitives.EC2InstanceType.Type
    object ISO8601DatetimeString extends Subtype[String]
    type ISO8601DatetimeString =
      zio.aws.mgn.model.primitives.ISO8601DatetimeString.Type
    object ISO8601DurationString extends Subtype[String]
    type ISO8601DurationString =
      zio.aws.mgn.model.primitives.ISO8601DurationString.Type
    object JobID extends Subtype[String]
    type JobID = zio.aws.mgn.model.primitives.JobID.Type
    object LargeBoundedString extends Subtype[String]
    type LargeBoundedString =
      zio.aws.mgn.model.primitives.LargeBoundedString.Type
    object LaunchConfigurationTemplateID extends Subtype[String]
    type LaunchConfigurationTemplateID =
      zio.aws.mgn.model.primitives.LaunchConfigurationTemplateID.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken = zio.aws.mgn.model.primitives.PaginationToken.Type
    object PositiveInteger extends Subtype[Long]
    type PositiveInteger = zio.aws.mgn.model.primitives.PositiveInteger.Type
    object ReplicationConfigurationTemplateID extends Subtype[String]
    type ReplicationConfigurationTemplateID =
      zio.aws.mgn.model.primitives.ReplicationConfigurationTemplateID.Type
    object S3LogBucketName extends Subtype[String]
    type S3LogBucketName = zio.aws.mgn.model.primitives.S3LogBucketName.Type
    object SecurityGroupID extends Subtype[String]
    type SecurityGroupID = zio.aws.mgn.model.primitives.SecurityGroupID.Type
    object SmallBoundedString extends Subtype[String]
    type SmallBoundedString =
      zio.aws.mgn.model.primitives.SmallBoundedString.Type
    object SourceServerID extends Subtype[String]
    type SourceServerID = zio.aws.mgn.model.primitives.SourceServerID.Type
    object SsmDocumentName extends Subtype[String]
    type SsmDocumentName = zio.aws.mgn.model.primitives.SsmDocumentName.Type
    object SsmDocumentParameterName extends Subtype[String]
    type SsmDocumentParameterName =
      zio.aws.mgn.model.primitives.SsmDocumentParameterName.Type
    object SsmParameterStoreParameterName extends Subtype[String]
    type SsmParameterStoreParameterName =
      zio.aws.mgn.model.primitives.SsmParameterStoreParameterName.Type
    object StrictlyPositiveInteger extends Subtype[Int]
    type StrictlyPositiveInteger =
      zio.aws.mgn.model.primitives.StrictlyPositiveInteger.Type
    object SubnetID extends Subtype[String]
    type SubnetID = zio.aws.mgn.model.primitives.SubnetID.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.mgn.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.mgn.model.primitives.TagValue.Type
    object VcenterClientID extends Subtype[String]
    type VcenterClientID = zio.aws.mgn.model.primitives.VcenterClientID.Type
  }
  type Cpus = List[zio.aws.mgn.model.CPU]
  type DataReplicationInfoReplicatedDisks =
    List[zio.aws.mgn.model.DataReplicationInfoReplicatedDisk]
  type DataReplicationInitiationSteps =
    List[zio.aws.mgn.model.DataReplicationInitiationStep]
  type DescribeJobsRequestFiltersJobIDs = List[JobID]
  type DescribeSourceServersRequestFiltersIDs = List[SourceServerID]
  type Disks = List[zio.aws.mgn.model.Disk]
  type IPsList = List[BoundedString]
  type JobLogs = List[zio.aws.mgn.model.JobLog]
  type JobsList = List[zio.aws.mgn.model.Job]
  type LaunchConfigurationTemplateIDs = List[LaunchConfigurationTemplateID]
  type LaunchConfigurationTemplates =
    List[zio.aws.mgn.model.LaunchConfigurationTemplate]
  type LifeCycleStates = List[zio.aws.mgn.model.LifeCycleState]
  type NetworkInterfaces = List[zio.aws.mgn.model.NetworkInterface]
  type ParticipatingServers = List[zio.aws.mgn.model.ParticipatingServer]
  type PostLaunchActionsLaunchStatusList =
    List[zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus]
  type ReplicationConfigurationReplicatedDisks =
    List[zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk]
  type ReplicationConfigurationTemplateIDs =
    List[ReplicationConfigurationTemplateID]
  type ReplicationConfigurationTemplates =
    List[zio.aws.mgn.model.ReplicationConfigurationTemplate]
  type ReplicationServersSecurityGroupsIDs = List[SecurityGroupID]
  type ReplicationTypes = List[zio.aws.mgn.model.ReplicationType]
  type SourceServersList = List[zio.aws.mgn.model.SourceServer]
  type SsmDocumentParameters = Map[SsmDocumentParameterName, Iterable[
    zio.aws.mgn.model.SsmParameterStoreParameter
  ]]
  type SsmDocuments = List[zio.aws.mgn.model.SsmDocument]
  type SsmParameterStoreParameters =
    List[zio.aws.mgn.model.SsmParameterStoreParameter]
  type StartCutoverRequestSourceServerIDs = List[SourceServerID]
  type StartTestRequestSourceServerIDs = List[SourceServerID]
  type TagKeys = List[TagKey]
  type TagsMap = Map[TagKey, TagValue]
  type TerminateTargetInstancesRequestSourceServerIDs = List[SourceServerID]
  type VcenterClientList = List[zio.aws.mgn.model.VcenterClient]
}
