package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.ApplicationID
import scala.jdk.CollectionConverters._
final case class DeleteApplicationRequest(applicationID: ApplicationID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DeleteApplicationRequest
      .builder()
      .applicationID(ApplicationID.unwrap(applicationID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DeleteApplicationRequest.ReadOnly =
    zio.aws.mgn.model.DeleteApplicationRequest.wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DeleteApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DeleteApplicationRequest =
      zio.aws.mgn.model.DeleteApplicationRequest(applicationID)
    def applicationID: ApplicationID
    def getApplicationID: ZIO[Any, Nothing, ApplicationID] =
      ZIO.succeed(applicationID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DeleteApplicationRequest
  ) extends zio.aws.mgn.model.DeleteApplicationRequest.ReadOnly {
    override val applicationID: ApplicationID =
      zio.aws.mgn.model.primitives.ApplicationID(impl.applicationID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DeleteApplicationRequest
  ): zio.aws.mgn.model.DeleteApplicationRequest.ReadOnly = new Wrapper(impl)
}
