package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.ReplicationConfigurationTemplateID
import scala.jdk.CollectionConverters._
final case class DeleteReplicationConfigurationTemplateRequest(
    replicationConfigurationTemplateID: ReplicationConfigurationTemplateID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateRequest = {
    import DeleteReplicationConfigurationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateRequest
      .builder()
      .replicationConfigurationTemplateID(
        ReplicationConfigurationTemplateID.unwrap(
          replicationConfigurationTemplateID
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.DeleteReplicationConfigurationTemplateRequest.ReadOnly =
    zio.aws.mgn.model.DeleteReplicationConfigurationTemplateRequest
      .wrap(buildAwsValue())
}
object DeleteReplicationConfigurationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mgn.model.DeleteReplicationConfigurationTemplateRequest =
      zio.aws.mgn.model.DeleteReplicationConfigurationTemplateRequest(
        replicationConfigurationTemplateID
      )
    def replicationConfigurationTemplateID: ReplicationConfigurationTemplateID
    def getReplicationConfigurationTemplateID
        : ZIO[Any, Nothing, ReplicationConfigurationTemplateID] =
      ZIO.succeed(replicationConfigurationTemplateID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateRequest
  ) extends zio.aws.mgn.model.DeleteReplicationConfigurationTemplateRequest.ReadOnly {
    override val replicationConfigurationTemplateID
        : ReplicationConfigurationTemplateID =
      zio.aws.mgn.model.primitives.ReplicationConfigurationTemplateID(
        impl.replicationConfigurationTemplateID()
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateRequest
  ): zio.aws.mgn.model.DeleteReplicationConfigurationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
