package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{BoundedString, EC2InstanceID}
import scala.jdk.CollectionConverters._
final case class IdentificationHints(
    awsInstanceID: Optional[EC2InstanceID] = Optional.Absent,
    fqdn: Optional[BoundedString] = Optional.Absent,
    hostname: Optional[BoundedString] = Optional.Absent,
    vmPath: Optional[BoundedString] = Optional.Absent,
    vmWareUuid: Optional[BoundedString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.IdentificationHints = {
    import IdentificationHints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.IdentificationHints
      .builder()
      .optionallyWith(
        awsInstanceID.map(value =>
          EC2InstanceID.unwrap(value): java.lang.String
        )
      )(_.awsInstanceID)
      .optionallyWith(
        fqdn.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.fqdn)
      .optionallyWith(
        hostname.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.hostname)
      .optionallyWith(
        vmPath.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.vmPath)
      .optionallyWith(
        vmWareUuid.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.vmWareUuid)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.IdentificationHints.ReadOnly =
    zio.aws.mgn.model.IdentificationHints.wrap(buildAwsValue())
}
object IdentificationHints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.IdentificationHints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.IdentificationHints =
      zio.aws.mgn.model.IdentificationHints(
        awsInstanceID.map(value => value),
        fqdn.map(value => value),
        hostname.map(value => value),
        vmPath.map(value => value),
        vmWareUuid.map(value => value)
      )
    def awsInstanceID: Optional[EC2InstanceID]
    def fqdn: Optional[BoundedString]
    def hostname: Optional[BoundedString]
    def vmPath: Optional[BoundedString]
    def vmWareUuid: Optional[BoundedString]
    def getAwsInstanceID: ZIO[Any, AwsError, EC2InstanceID] =
      AwsError.unwrapOptionField("awsInstanceID", awsInstanceID)
    def getFqdn: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("fqdn", fqdn)
    def getHostname: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getVmPath: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("vmPath", vmPath)
    def getVmWareUuid: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("vmWareUuid", vmWareUuid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.IdentificationHints
  ) extends zio.aws.mgn.model.IdentificationHints.ReadOnly {
    override val awsInstanceID: Optional[EC2InstanceID] = zio.aws.core.internal
      .optionalFromNullable(impl.awsInstanceID())
      .map(value => zio.aws.mgn.model.primitives.EC2InstanceID(value))
    override val fqdn: Optional[BoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.fqdn())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val hostname: Optional[BoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.hostname())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val vmPath: Optional[BoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.vmPath())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val vmWareUuid: Optional[BoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.vmWareUuid())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.IdentificationHints
  ): zio.aws.mgn.model.IdentificationHints.ReadOnly = new Wrapper(impl)
}
