package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait InitiatedBy {
  def unwrap: software.amazon.awssdk.services.mgn.model.InitiatedBy
}
object InitiatedBy {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.InitiatedBy
  ): zio.aws.mgn.model.InitiatedBy = value match {
    case software.amazon.awssdk.services.mgn.model.InitiatedBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.InitiatedBy.START_TEST =>
      val r = START_TEST
      r
    case software.amazon.awssdk.services.mgn.model.InitiatedBy.START_CUTOVER =>
      val r = START_CUTOVER
      r
    case software.amazon.awssdk.services.mgn.model.InitiatedBy.DIAGNOSTIC =>
      val r = DIAGNOSTIC
      r
    case software.amazon.awssdk.services.mgn.model.InitiatedBy.TERMINATE =>
      val r = TERMINATE
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.InitiatedBy {
    override def unwrap: software.amazon.awssdk.services.mgn.model.InitiatedBy =
      software.amazon.awssdk.services.mgn.model.InitiatedBy.UNKNOWN_TO_SDK_VERSION
  }
  case object START_TEST extends zio.aws.mgn.model.InitiatedBy {
    override def unwrap: software.amazon.awssdk.services.mgn.model.InitiatedBy =
      software.amazon.awssdk.services.mgn.model.InitiatedBy.START_TEST
  }
  case object START_CUTOVER extends zio.aws.mgn.model.InitiatedBy {
    override def unwrap: software.amazon.awssdk.services.mgn.model.InitiatedBy =
      software.amazon.awssdk.services.mgn.model.InitiatedBy.START_CUTOVER
  }
  case object DIAGNOSTIC extends zio.aws.mgn.model.InitiatedBy {
    override def unwrap: software.amazon.awssdk.services.mgn.model.InitiatedBy =
      software.amazon.awssdk.services.mgn.model.InitiatedBy.DIAGNOSTIC
  }
  case object TERMINATE extends zio.aws.mgn.model.InitiatedBy {
    override def unwrap: software.amazon.awssdk.services.mgn.model.InitiatedBy =
      software.amazon.awssdk.services.mgn.model.InitiatedBy.TERMINATE
  }
}
