package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.BoundedString
import scala.jdk.CollectionConverters._
final case class JobPostLaunchActionsLaunchStatus(
    executionID: Optional[BoundedString] = Optional.Absent,
    executionStatus: Optional[
      zio.aws.mgn.model.PostLaunchActionExecutionStatus
    ] = Optional.Absent,
    failureReason: Optional[BoundedString] = Optional.Absent,
    ssmDocument: Optional[zio.aws.mgn.model.SsmDocument] = Optional.Absent,
    ssmDocumentType: Optional[zio.aws.mgn.model.SsmDocumentType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.JobPostLaunchActionsLaunchStatus = {
    import JobPostLaunchActionsLaunchStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.JobPostLaunchActionsLaunchStatus
      .builder()
      .optionallyWith(
        executionID.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.executionID)
      .optionallyWith(executionStatus.map(value => value.unwrap))(
        _.executionStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          BoundedString.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(ssmDocument.map(value => value.buildAwsValue()))(
        _.ssmDocument
      )
      .optionallyWith(ssmDocumentType.map(value => value.unwrap))(
        _.ssmDocumentType
      )
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus.ReadOnly =
    zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus.wrap(buildAwsValue())
}
object JobPostLaunchActionsLaunchStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.JobPostLaunchActionsLaunchStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus =
      zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus(
        executionID.map(value => value),
        executionStatus.map(value => value),
        failureReason.map(value => value),
        ssmDocument.map(value => value.asEditable),
        ssmDocumentType.map(value => value)
      )
    def executionID: Optional[BoundedString]
    def executionStatus
        : Optional[zio.aws.mgn.model.PostLaunchActionExecutionStatus]
    def failureReason: Optional[BoundedString]
    def ssmDocument: Optional[zio.aws.mgn.model.SsmDocument.ReadOnly]
    def ssmDocumentType: Optional[zio.aws.mgn.model.SsmDocumentType]
    def getExecutionID: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("executionID", executionID)
    def getExecutionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.PostLaunchActionExecutionStatus
    ] = AwsError.unwrapOptionField("executionStatus", executionStatus)
    def getFailureReason: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSsmDocument
        : ZIO[Any, AwsError, zio.aws.mgn.model.SsmDocument.ReadOnly] =
      AwsError.unwrapOptionField("ssmDocument", ssmDocument)
    def getSsmDocumentType
        : ZIO[Any, AwsError, zio.aws.mgn.model.SsmDocumentType] =
      AwsError.unwrapOptionField("ssmDocumentType", ssmDocumentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.JobPostLaunchActionsLaunchStatus
  ) extends zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus.ReadOnly {
    override val executionID: Optional[BoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.executionID())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val executionStatus
        : Optional[zio.aws.mgn.model.PostLaunchActionExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionStatus())
        .map(value =>
          zio.aws.mgn.model.PostLaunchActionExecutionStatus.wrap(value)
        )
    override val failureReason: Optional[BoundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val ssmDocument: Optional[zio.aws.mgn.model.SsmDocument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssmDocument())
        .map(value => zio.aws.mgn.model.SsmDocument.wrap(value))
    override val ssmDocumentType: Optional[zio.aws.mgn.model.SsmDocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssmDocumentType())
        .map(value => zio.aws.mgn.model.SsmDocumentType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.JobPostLaunchActionsLaunchStatus
  ): zio.aws.mgn.model.JobPostLaunchActionsLaunchStatus.ReadOnly = new Wrapper(
    impl
  )
}
