package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{
  StrictlyPositiveInteger,
  BoundedString,
  ActionName,
  DocumentVersion,
  SsmDocumentParameterName,
  ActionID,
  OrderType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PutSourceServerActionResponse(
    actionID: Optional[ActionID] = Optional.Absent,
    actionName: Optional[ActionName] = Optional.Absent,
    active: Optional[Boolean] = Optional.Absent,
    documentIdentifier: Optional[BoundedString] = Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    mustSucceedForCutover: Optional[Boolean] = Optional.Absent,
    order: Optional[OrderType] = Optional.Absent,
    parameters: Optional[Map[SsmDocumentParameterName, Iterable[
      zio.aws.mgn.model.SsmParameterStoreParameter
    ]]] = Optional.Absent,
    timeoutSeconds: Optional[StrictlyPositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.PutSourceServerActionResponse = {
    import PutSourceServerActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.PutSourceServerActionResponse
      .builder()
      .optionallyWith(
        actionID.map(value => ActionID.unwrap(value): java.lang.String)
      )(_.actionID)
      .optionallyWith(
        actionName.map(value => ActionName.unwrap(value): java.lang.String)
      )(_.actionName)
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .optionallyWith(
        documentIdentifier.map(value =>
          BoundedString.unwrap(value): java.lang.String
        )
      )(_.documentIdentifier)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        mustSucceedForCutover.map(value => value: java.lang.Boolean)
      )(_.mustSucceedForCutover)
      .optionallyWith(order.map(value => OrderType.unwrap(value): Integer))(
        _.order
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (SsmDocumentParameterName
                .unwrap(key): java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        timeoutSeconds.map(value =>
          StrictlyPositiveInteger.unwrap(value): Integer
        )
      )(_.timeoutSeconds)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.PutSourceServerActionResponse.ReadOnly =
    zio.aws.mgn.model.PutSourceServerActionResponse.wrap(buildAwsValue())
}
object PutSourceServerActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.PutSourceServerActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.PutSourceServerActionResponse =
      zio.aws.mgn.model.PutSourceServerActionResponse(
        actionID.map(value => value),
        actionName.map(value => value),
        active.map(value => value),
        documentIdentifier.map(value => value),
        documentVersion.map(value => value),
        mustSucceedForCutover.map(value => value),
        order.map(value => value),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        timeoutSeconds.map(value => value)
      )
    def actionID: Optional[ActionID]
    def actionName: Optional[ActionName]
    def active: Optional[Boolean]
    def documentIdentifier: Optional[BoundedString]
    def documentVersion: Optional[DocumentVersion]
    def mustSucceedForCutover: Optional[Boolean]
    def order: Optional[OrderType]
    def parameters: Optional[Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]]
    def timeoutSeconds: Optional[StrictlyPositiveInteger]
    def getActionID: ZIO[Any, AwsError, ActionID] =
      AwsError.unwrapOptionField("actionID", actionID)
    def getActionName: ZIO[Any, AwsError, ActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("active", active)
    def getDocumentIdentifier: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("documentIdentifier", documentIdentifier)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getMustSucceedForCutover: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mustSucceedForCutover", mustSucceedForCutover)
    def getOrder: ZIO[Any, AwsError, OrderType] =
      AwsError.unwrapOptionField("order", order)
    def getParameters: ZIO[Any, AwsError, Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getTimeoutSeconds: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.PutSourceServerActionResponse
  ) extends zio.aws.mgn.model.PutSourceServerActionResponse.ReadOnly {
    override val actionID: Optional[ActionID] = zio.aws.core.internal
      .optionalFromNullable(impl.actionID())
      .map(value => zio.aws.mgn.model.primitives.ActionID(value))
    override val actionName: Optional[ActionName] = zio.aws.core.internal
      .optionalFromNullable(impl.actionName())
      .map(value => zio.aws.mgn.model.primitives.ActionName(value))
    override val active: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value => value: Boolean)
    override val documentIdentifier: Optional[BoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentIdentifier())
        .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.mgn.model.primitives.DocumentVersion(value))
    override val mustSucceedForCutover: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mustSucceedForCutover())
        .map(value => value: Boolean)
    override val order: Optional[OrderType] = zio.aws.core.internal
      .optionalFromNullable(impl.order())
      .map(value => zio.aws.mgn.model.primitives.OrderType(value))
    override val parameters: Optional[Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .SsmDocumentParameterName(key) -> value.asScala.map { item =>
              zio.aws.mgn.model.SsmParameterStoreParameter.wrap(item)
            }.toList
          })
          .toMap
      )
    override val timeoutSeconds: Optional[StrictlyPositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutSeconds())
        .map(value =>
          zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.PutSourceServerActionResponse
  ): zio.aws.mgn.model.PutSourceServerActionResponse.ReadOnly = new Wrapper(
    impl
  )
}
