package zio.aws.mgn.model
import zio.aws.mgn.model.primitives.{
  StrictlyPositiveInteger,
  BoundedString,
  DocumentVersion,
  SsmDocumentParameterName,
  ActionID,
  OperatingSystemString,
  LaunchConfigurationTemplateID,
  OrderType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PutTemplateActionRequest(
    actionID: ActionID,
    actionName: BoundedString,
    active: Optional[Boolean] = Optional.Absent,
    documentIdentifier: BoundedString,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    launchConfigurationTemplateID: LaunchConfigurationTemplateID,
    mustSucceedForCutover: Optional[Boolean] = Optional.Absent,
    operatingSystem: Optional[OperatingSystemString] = Optional.Absent,
    order: OrderType,
    parameters: Optional[Map[SsmDocumentParameterName, Iterable[
      zio.aws.mgn.model.SsmParameterStoreParameter
    ]]] = Optional.Absent,
    timeoutSeconds: Optional[StrictlyPositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.PutTemplateActionRequest = {
    import PutTemplateActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.PutTemplateActionRequest
      .builder()
      .actionID(ActionID.unwrap(actionID): java.lang.String)
      .actionName(BoundedString.unwrap(actionName): java.lang.String)
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .documentIdentifier(
        BoundedString.unwrap(documentIdentifier): java.lang.String
      )
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .launchConfigurationTemplateID(
        LaunchConfigurationTemplateID.unwrap(
          launchConfigurationTemplateID
        ): java.lang.String
      )
      .optionallyWith(
        mustSucceedForCutover.map(value => value: java.lang.Boolean)
      )(_.mustSucceedForCutover)
      .optionallyWith(
        operatingSystem.map(value =>
          OperatingSystemString.unwrap(value): java.lang.String
        )
      )(_.operatingSystem)
      .order(OrderType.unwrap(order): Integer)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (SsmDocumentParameterName
                .unwrap(key): java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        timeoutSeconds.map(value =>
          StrictlyPositiveInteger.unwrap(value): Integer
        )
      )(_.timeoutSeconds)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.PutTemplateActionRequest.ReadOnly =
    zio.aws.mgn.model.PutTemplateActionRequest.wrap(buildAwsValue())
}
object PutTemplateActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.PutTemplateActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.PutTemplateActionRequest =
      zio.aws.mgn.model.PutTemplateActionRequest(
        actionID,
        actionName,
        active.map(value => value),
        documentIdentifier,
        documentVersion.map(value => value),
        launchConfigurationTemplateID,
        mustSucceedForCutover.map(value => value),
        operatingSystem.map(value => value),
        order,
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        timeoutSeconds.map(value => value)
      )
    def actionID: ActionID
    def actionName: BoundedString
    def active: Optional[Boolean]
    def documentIdentifier: BoundedString
    def documentVersion: Optional[DocumentVersion]
    def launchConfigurationTemplateID: LaunchConfigurationTemplateID
    def mustSucceedForCutover: Optional[Boolean]
    def operatingSystem: Optional[OperatingSystemString]
    def order: OrderType
    def parameters: Optional[Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]]
    def timeoutSeconds: Optional[StrictlyPositiveInteger]
    def getActionID: ZIO[Any, Nothing, ActionID] = ZIO.succeed(actionID)
    def getActionName: ZIO[Any, Nothing, BoundedString] =
      ZIO.succeed(actionName)
    def getActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("active", active)
    def getDocumentIdentifier: ZIO[Any, Nothing, BoundedString] =
      ZIO.succeed(documentIdentifier)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getLaunchConfigurationTemplateID
        : ZIO[Any, Nothing, LaunchConfigurationTemplateID] =
      ZIO.succeed(launchConfigurationTemplateID)
    def getMustSucceedForCutover: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mustSucceedForCutover", mustSucceedForCutover)
    def getOperatingSystem: ZIO[Any, AwsError, OperatingSystemString] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getOrder: ZIO[Any, Nothing, OrderType] = ZIO.succeed(order)
    def getParameters: ZIO[Any, AwsError, Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getTimeoutSeconds: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.PutTemplateActionRequest
  ) extends zio.aws.mgn.model.PutTemplateActionRequest.ReadOnly {
    override val actionID: ActionID =
      zio.aws.mgn.model.primitives.ActionID(impl.actionID())
    override val actionName: BoundedString =
      zio.aws.mgn.model.primitives.BoundedString(impl.actionName())
    override val active: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value => value: Boolean)
    override val documentIdentifier: BoundedString =
      zio.aws.mgn.model.primitives.BoundedString(impl.documentIdentifier())
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.mgn.model.primitives.DocumentVersion(value))
    override val launchConfigurationTemplateID: LaunchConfigurationTemplateID =
      zio.aws.mgn.model.primitives
        .LaunchConfigurationTemplateID(impl.launchConfigurationTemplateID())
    override val mustSucceedForCutover: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mustSucceedForCutover())
        .map(value => value: Boolean)
    override val operatingSystem: Optional[OperatingSystemString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.mgn.model.primitives.OperatingSystemString(value))
    override val order: OrderType =
      zio.aws.mgn.model.primitives.OrderType(impl.order())
    override val parameters: Optional[Map[SsmDocumentParameterName, List[
      zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .SsmDocumentParameterName(key) -> value.asScala.map { item =>
              zio.aws.mgn.model.SsmParameterStoreParameter.wrap(item)
            }.toList
          })
          .toMap
      )
    override val timeoutSeconds: Optional[StrictlyPositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutSeconds())
        .map(value =>
          zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.PutTemplateActionRequest
  ): zio.aws.mgn.model.PutTemplateActionRequest.ReadOnly = new Wrapper(impl)
}
