package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.{SourceServerID, ActionID}
import scala.jdk.CollectionConverters._
final case class RemoveSourceServerActionRequest(
    actionID: ActionID,
    sourceServerID: SourceServerID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest = {
    import RemoveSourceServerActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest
      .builder()
      .actionID(ActionID.unwrap(actionID): java.lang.String)
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.RemoveSourceServerActionRequest.ReadOnly =
    zio.aws.mgn.model.RemoveSourceServerActionRequest.wrap(buildAwsValue())
}
object RemoveSourceServerActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.RemoveSourceServerActionRequest =
      zio.aws.mgn.model
        .RemoveSourceServerActionRequest(actionID, sourceServerID)
    def actionID: ActionID
    def sourceServerID: SourceServerID
    def getActionID: ZIO[Any, Nothing, ActionID] = ZIO.succeed(actionID)
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest
  ) extends zio.aws.mgn.model.RemoveSourceServerActionRequest.ReadOnly {
    override val actionID: ActionID =
      zio.aws.mgn.model.primitives.ActionID(impl.actionID())
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest
  ): zio.aws.mgn.model.RemoveSourceServerActionRequest.ReadOnly = new Wrapper(
    impl
  )
}
