package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.ActionID
import scala.jdk.CollectionConverters._
final case class SourceServerActionsRequestFilters(
    actionIDs: Optional[Iterable[ActionID]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.SourceServerActionsRequestFilters = {
    import SourceServerActionsRequestFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.SourceServerActionsRequestFilters
      .builder()
      .optionallyWith(
        actionIDs.map(value =>
          value.map { item =>
            ActionID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.actionIDs)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.SourceServerActionsRequestFilters.ReadOnly =
    zio.aws.mgn.model.SourceServerActionsRequestFilters.wrap(buildAwsValue())
}
object SourceServerActionsRequestFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.SourceServerActionsRequestFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.SourceServerActionsRequestFilters =
      zio.aws.mgn.model
        .SourceServerActionsRequestFilters(actionIDs.map(value => value))
    def actionIDs: Optional[List[ActionID]]
    def getActionIDs: ZIO[Any, AwsError, List[ActionID]] =
      AwsError.unwrapOptionField("actionIDs", actionIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.SourceServerActionsRequestFilters
  ) extends zio.aws.mgn.model.SourceServerActionsRequestFilters.ReadOnly {
    override val actionIDs: Optional[List[ActionID]] = zio.aws.core.internal
      .optionalFromNullable(impl.actionIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.ActionID(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.SourceServerActionsRequestFilters
  ): zio.aws.mgn.model.SourceServerActionsRequestFilters.ReadOnly = new Wrapper(
    impl
  )
}
