package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.SsmParameterStoreParameterName
import scala.jdk.CollectionConverters._
final case class SsmParameterStoreParameter(
    parameterName: SsmParameterStoreParameterName,
    parameterType: zio.aws.mgn.model.SsmParameterStoreParameterType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.SsmParameterStoreParameter = {
    import SsmParameterStoreParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.SsmParameterStoreParameter
      .builder()
      .parameterName(
        SsmParameterStoreParameterName.unwrap(parameterName): java.lang.String
      )
      .parameterType(parameterType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly =
    zio.aws.mgn.model.SsmParameterStoreParameter.wrap(buildAwsValue())
}
object SsmParameterStoreParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.SsmParameterStoreParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.SsmParameterStoreParameter =
      zio.aws.mgn.model.SsmParameterStoreParameter(parameterName, parameterType)
    def parameterName: SsmParameterStoreParameterName
    def parameterType: zio.aws.mgn.model.SsmParameterStoreParameterType
    def getParameterName: ZIO[Any, Nothing, SsmParameterStoreParameterName] =
      ZIO.succeed(parameterName)
    def getParameterType
        : ZIO[Any, Nothing, zio.aws.mgn.model.SsmParameterStoreParameterType] =
      ZIO.succeed(parameterType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.SsmParameterStoreParameter
  ) extends zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly {
    override val parameterName: SsmParameterStoreParameterName =
      zio.aws.mgn.model.primitives
        .SsmParameterStoreParameterName(impl.parameterName())
    override val parameterType
        : zio.aws.mgn.model.SsmParameterStoreParameterType =
      zio.aws.mgn.model.SsmParameterStoreParameterType
        .wrap(impl.parameterType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.SsmParameterStoreParameter
  ): zio.aws.mgn.model.SsmParameterStoreParameter.ReadOnly = new Wrapper(impl)
}
