package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.ApplicationID
import scala.jdk.CollectionConverters._
final case class UnarchiveApplicationRequest(applicationID: ApplicationID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest = {
    import UnarchiveApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest
      .builder()
      .applicationID(ApplicationID.unwrap(applicationID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.UnarchiveApplicationRequest.ReadOnly =
    zio.aws.mgn.model.UnarchiveApplicationRequest.wrap(buildAwsValue())
}
object UnarchiveApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UnarchiveApplicationRequest =
      zio.aws.mgn.model.UnarchiveApplicationRequest(applicationID)
    def applicationID: ApplicationID
    def getApplicationID: ZIO[Any, Nothing, ApplicationID] =
      ZIO.succeed(applicationID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest
  ) extends zio.aws.mgn.model.UnarchiveApplicationRequest.ReadOnly {
    override val applicationID: ApplicationID =
      zio.aws.mgn.model.primitives.ApplicationID(impl.applicationID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest
  ): zio.aws.mgn.model.UnarchiveApplicationRequest.ReadOnly = new Wrapper(impl)
}
