package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mgn.model.primitives.{
  PositiveInteger,
  TagValue,
  LaunchConfigurationTemplateID
}
import scala.jdk.CollectionConverters._
final case class UpdateLaunchConfigurationTemplateRequest(
    associatePublicIpAddress: Optional[Boolean] = Optional.Absent,
    bootMode: Optional[zio.aws.mgn.model.BootMode] = Optional.Absent,
    copyPrivateIp: Optional[Boolean] = Optional.Absent,
    copyTags: Optional[Boolean] = Optional.Absent,
    enableMapAutoTagging: Optional[Boolean] = Optional.Absent,
    largeVolumeConf: Optional[zio.aws.mgn.model.LaunchTemplateDiskConf] =
      Optional.Absent,
    launchConfigurationTemplateID: LaunchConfigurationTemplateID,
    launchDisposition: Optional[zio.aws.mgn.model.LaunchDisposition] =
      Optional.Absent,
    licensing: Optional[zio.aws.mgn.model.Licensing] = Optional.Absent,
    mapAutoTaggingMpeID: Optional[TagValue] = Optional.Absent,
    postLaunchActions: Optional[zio.aws.mgn.model.PostLaunchActions] =
      Optional.Absent,
    smallVolumeConf: Optional[zio.aws.mgn.model.LaunchTemplateDiskConf] =
      Optional.Absent,
    smallVolumeMaxSize: Optional[PositiveInteger] = Optional.Absent,
    targetInstanceTypeRightSizingMethod: Optional[
      zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest = {
    import UpdateLaunchConfigurationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest
      .builder()
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .optionallyWith(copyPrivateIp.map(value => value: java.lang.Boolean))(
        _.copyPrivateIp
      )
      .optionallyWith(copyTags.map(value => value: java.lang.Boolean))(
        _.copyTags
      )
      .optionallyWith(
        enableMapAutoTagging.map(value => value: java.lang.Boolean)
      )(_.enableMapAutoTagging)
      .optionallyWith(largeVolumeConf.map(value => value.buildAwsValue()))(
        _.largeVolumeConf
      )
      .launchConfigurationTemplateID(
        LaunchConfigurationTemplateID.unwrap(
          launchConfigurationTemplateID
        ): java.lang.String
      )
      .optionallyWith(launchDisposition.map(value => value.unwrap))(
        _.launchDisposition
      )
      .optionallyWith(licensing.map(value => value.buildAwsValue()))(
        _.licensing
      )
      .optionallyWith(
        mapAutoTaggingMpeID.map(value =>
          TagValue.unwrap(value): java.lang.String
        )
      )(_.mapAutoTaggingMpeID)
      .optionallyWith(postLaunchActions.map(value => value.buildAwsValue()))(
        _.postLaunchActions
      )
      .optionallyWith(smallVolumeConf.map(value => value.buildAwsValue()))(
        _.smallVolumeConf
      )
      .optionallyWith(
        smallVolumeMaxSize.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.smallVolumeMaxSize)
      .optionallyWith(
        targetInstanceTypeRightSizingMethod.map(value => value.unwrap)
      )(_.targetInstanceTypeRightSizingMethod)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest.ReadOnly =
    zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest
      .wrap(buildAwsValue())
}
object UpdateLaunchConfigurationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest =
      zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest(
        associatePublicIpAddress.map(value => value),
        bootMode.map(value => value),
        copyPrivateIp.map(value => value),
        copyTags.map(value => value),
        enableMapAutoTagging.map(value => value),
        largeVolumeConf.map(value => value.asEditable),
        launchConfigurationTemplateID,
        launchDisposition.map(value => value),
        licensing.map(value => value.asEditable),
        mapAutoTaggingMpeID.map(value => value),
        postLaunchActions.map(value => value.asEditable),
        smallVolumeConf.map(value => value.asEditable),
        smallVolumeMaxSize.map(value => value),
        targetInstanceTypeRightSizingMethod.map(value => value)
      )
    def associatePublicIpAddress: Optional[Boolean]
    def bootMode: Optional[zio.aws.mgn.model.BootMode]
    def copyPrivateIp: Optional[Boolean]
    def copyTags: Optional[Boolean]
    def enableMapAutoTagging: Optional[Boolean]
    def largeVolumeConf
        : Optional[zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly]
    def launchConfigurationTemplateID: LaunchConfigurationTemplateID
    def launchDisposition: Optional[zio.aws.mgn.model.LaunchDisposition]
    def licensing: Optional[zio.aws.mgn.model.Licensing.ReadOnly]
    def mapAutoTaggingMpeID: Optional[TagValue]
    def postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly]
    def smallVolumeConf
        : Optional[zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly]
    def smallVolumeMaxSize: Optional[PositiveInteger]
    def targetInstanceTypeRightSizingMethod
        : Optional[zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod]
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getBootMode: ZIO[Any, AwsError, zio.aws.mgn.model.BootMode] =
      AwsError.unwrapOptionField("bootMode", bootMode)
    def getCopyPrivateIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyPrivateIp", copyPrivateIp)
    def getCopyTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getEnableMapAutoTagging: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableMapAutoTagging", enableMapAutoTagging)
    def getLargeVolumeConf: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly
    ] = AwsError.unwrapOptionField("largeVolumeConf", largeVolumeConf)
    def getLaunchConfigurationTemplateID
        : ZIO[Any, Nothing, LaunchConfigurationTemplateID] =
      ZIO.succeed(launchConfigurationTemplateID)
    def getLaunchDisposition
        : ZIO[Any, AwsError, zio.aws.mgn.model.LaunchDisposition] =
      AwsError.unwrapOptionField("launchDisposition", launchDisposition)
    def getLicensing: ZIO[Any, AwsError, zio.aws.mgn.model.Licensing.ReadOnly] =
      AwsError.unwrapOptionField("licensing", licensing)
    def getMapAutoTaggingMpeID: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("mapAutoTaggingMpeID", mapAutoTaggingMpeID)
    def getPostLaunchActions
        : ZIO[Any, AwsError, zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      AwsError.unwrapOptionField("postLaunchActions", postLaunchActions)
    def getSmallVolumeConf: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly
    ] = AwsError.unwrapOptionField("smallVolumeConf", smallVolumeConf)
    def getSmallVolumeMaxSize: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("smallVolumeMaxSize", smallVolumeMaxSize)
    def getTargetInstanceTypeRightSizingMethod: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod
    ] = AwsError.unwrapOptionField(
      "targetInstanceTypeRightSizingMethod",
      targetInstanceTypeRightSizingMethod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest
  ) extends zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest.ReadOnly {
    override val associatePublicIpAddress: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatePublicIpAddress())
        .map(value => value: Boolean)
    override val bootMode: Optional[zio.aws.mgn.model.BootMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootMode())
        .map(value => zio.aws.mgn.model.BootMode.wrap(value))
    override val copyPrivateIp: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyPrivateIp())
      .map(value => value: Boolean)
    override val copyTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTags())
      .map(value => value: Boolean)
    override val enableMapAutoTagging: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableMapAutoTagging())
      .map(value => value: Boolean)
    override val largeVolumeConf
        : Optional[zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.largeVolumeConf())
        .map(value => zio.aws.mgn.model.LaunchTemplateDiskConf.wrap(value))
    override val launchConfigurationTemplateID: LaunchConfigurationTemplateID =
      zio.aws.mgn.model.primitives
        .LaunchConfigurationTemplateID(impl.launchConfigurationTemplateID())
    override val launchDisposition
        : Optional[zio.aws.mgn.model.LaunchDisposition] = zio.aws.core.internal
      .optionalFromNullable(impl.launchDisposition())
      .map(value => zio.aws.mgn.model.LaunchDisposition.wrap(value))
    override val licensing: Optional[zio.aws.mgn.model.Licensing.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licensing())
        .map(value => zio.aws.mgn.model.Licensing.wrap(value))
    override val mapAutoTaggingMpeID: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.mapAutoTaggingMpeID())
      .map(value => zio.aws.mgn.model.primitives.TagValue(value))
    override val postLaunchActions
        : Optional[zio.aws.mgn.model.PostLaunchActions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postLaunchActions())
        .map(value => zio.aws.mgn.model.PostLaunchActions.wrap(value))
    override val smallVolumeConf
        : Optional[zio.aws.mgn.model.LaunchTemplateDiskConf.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smallVolumeConf())
        .map(value => zio.aws.mgn.model.LaunchTemplateDiskConf.wrap(value))
    override val smallVolumeMaxSize: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smallVolumeMaxSize())
        .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val targetInstanceTypeRightSizingMethod
        : Optional[zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetInstanceTypeRightSizingMethod())
        .map(value =>
          zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest
  ): zio.aws.mgn.model.UpdateLaunchConfigurationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
