package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait WaveHealthStatus {
  def unwrap: software.amazon.awssdk.services.mgn.model.WaveHealthStatus
}
object WaveHealthStatus {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.WaveHealthStatus
  ): zio.aws.mgn.model.WaveHealthStatus = value match {
    case software.amazon.awssdk.services.mgn.model.WaveHealthStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.WaveHealthStatus.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.mgn.model.WaveHealthStatus.LAGGING =>
      val r = LAGGING
      r
    case software.amazon.awssdk.services.mgn.model.WaveHealthStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.WaveHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.WaveHealthStatus =
      software.amazon.awssdk.services.mgn.model.WaveHealthStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY extends zio.aws.mgn.model.WaveHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.WaveHealthStatus =
      software.amazon.awssdk.services.mgn.model.WaveHealthStatus.HEALTHY
  }
  case object LAGGING extends zio.aws.mgn.model.WaveHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.WaveHealthStatus =
      software.amazon.awssdk.services.mgn.model.WaveHealthStatus.LAGGING
  }
  case object ERROR extends zio.aws.mgn.model.WaveHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.WaveHealthStatus =
      software.amazon.awssdk.services.mgn.model.WaveHealthStatus.ERROR
  }
}
