package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.WaveID
import scala.jdk.CollectionConverters._
final case class ArchiveWaveRequest(waveID: WaveID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ArchiveWaveRequest = {
    import ArchiveWaveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ArchiveWaveRequest
      .builder()
      .waveID(WaveID.unwrap(waveID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ArchiveWaveRequest.ReadOnly =
    zio.aws.mgn.model.ArchiveWaveRequest.wrap(buildAwsValue())
}
object ArchiveWaveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ArchiveWaveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ArchiveWaveRequest =
      zio.aws.mgn.model.ArchiveWaveRequest(waveID)
    def waveID: WaveID
    def getWaveID: ZIO[Any, Nothing, WaveID] = ZIO.succeed(waveID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ArchiveWaveRequest
  ) extends zio.aws.mgn.model.ArchiveWaveRequest.ReadOnly {
    override val waveID: WaveID =
      zio.aws.mgn.model.primitives.WaveID(impl.waveID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ArchiveWaveRequest
  ): zio.aws.mgn.model.ArchiveWaveRequest.ReadOnly = new Wrapper(impl)
}
