package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.LaunchConfigurationTemplateID
import scala.jdk.CollectionConverters._
final case class DeleteLaunchConfigurationTemplateRequest(
    launchConfigurationTemplateID: LaunchConfigurationTemplateID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateRequest = {
    import DeleteLaunchConfigurationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateRequest
      .builder()
      .launchConfigurationTemplateID(
        LaunchConfigurationTemplateID.unwrap(
          launchConfigurationTemplateID
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.DeleteLaunchConfigurationTemplateRequest.ReadOnly =
    zio.aws.mgn.model.DeleteLaunchConfigurationTemplateRequest
      .wrap(buildAwsValue())
}
object DeleteLaunchConfigurationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DeleteLaunchConfigurationTemplateRequest =
      zio.aws.mgn.model
        .DeleteLaunchConfigurationTemplateRequest(launchConfigurationTemplateID)
    def launchConfigurationTemplateID: LaunchConfigurationTemplateID
    def getLaunchConfigurationTemplateID
        : ZIO[Any, Nothing, LaunchConfigurationTemplateID] =
      ZIO.succeed(launchConfigurationTemplateID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateRequest
  ) extends zio.aws.mgn.model.DeleteLaunchConfigurationTemplateRequest.ReadOnly {
    override val launchConfigurationTemplateID: LaunchConfigurationTemplateID =
      zio.aws.mgn.model.primitives
        .LaunchConfigurationTemplateID(impl.launchConfigurationTemplateID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateRequest
  ): zio.aws.mgn.model.DeleteLaunchConfigurationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
