package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.WaveID
import scala.jdk.CollectionConverters._
final case class DeleteWaveRequest(waveID: WaveID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DeleteWaveRequest = {
    import DeleteWaveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DeleteWaveRequest
      .builder()
      .waveID(WaveID.unwrap(waveID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DeleteWaveRequest.ReadOnly =
    zio.aws.mgn.model.DeleteWaveRequest.wrap(buildAwsValue())
}
object DeleteWaveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DeleteWaveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DeleteWaveRequest =
      zio.aws.mgn.model.DeleteWaveRequest(waveID)
    def waveID: WaveID
    def getWaveID: ZIO[Any, Nothing, WaveID] = ZIO.succeed(waveID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DeleteWaveRequest
  ) extends zio.aws.mgn.model.DeleteWaveRequest.ReadOnly {
    override val waveID: WaveID =
      zio.aws.mgn.model.primitives.WaveID(impl.waveID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DeleteWaveRequest
  ): zio.aws.mgn.model.DeleteWaveRequest.ReadOnly = new Wrapper(impl)
}
